/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScriptedMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        List mojoDescriptors;
        String metadataExtension = this.getMetadataFileExtension();
        String scriptExtension = this.getScriptFileExtension();
        Map scriptFilesKeyedByBasedir = this.gatherFilesByBasedir(project.getBasedir(), project.getScriptSourceRoots(), scriptExtension);
        if (!StringUtils.isEmpty((String)metadataExtension)) {
            Map metadataFilesKeyedByBasedir = this.gatherFilesByBasedir(project.getBasedir(), project.getScriptSourceRoots(), metadataExtension);
            mojoDescriptors = this.extractMojoDescriptorsFromMetadata(metadataFilesKeyedByBasedir, pluginDescriptor);
        } else {
            mojoDescriptors = this.extractMojoDescriptors(scriptFilesKeyedByBasedir, pluginDescriptor);
        }
        this.copyScriptsToOutputDirectory(scriptFilesKeyedByBasedir, project.getBuild().getOutputDirectory());
        return mojoDescriptors;
    }

    protected void copyScriptsToOutputDirectory(Map scriptFilesKeyedByBasedir, String outputDirectory) throws ExtractionException {
        File outputDir = new File(outputDirectory);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        Iterator it = scriptFilesKeyedByBasedir.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            File sourceDir = new File((String)entry.getKey());
            Set scripts = (Set)entry.getValue();
            Iterator scriptIterator = scripts.iterator();
            while (scriptIterator.hasNext()) {
                File outputFile;
                File scriptFile = (File)scriptIterator.next();
                String relativePath = scriptFile.getPath().substring(sourceDir.getPath().length());
                if (relativePath.charAt(0) == File.separatorChar) {
                    relativePath = relativePath.substring(1);
                }
                if (!(outputFile = new File(outputDir, relativePath).getAbsoluteFile()).getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyFile((File)scriptFile, (File)outputFile);
                }
                catch (IOException e) {
                    throw new ExtractionException("Cannot copy script file: " + scriptFile + " to output: " + outputFile, e);
                }
            }
        }
    }

    protected Map gatherFilesByBasedir(File basedir, List directories, String scriptFileExtension) {
        TreeMap sourcesByBasedir = new TreeMap();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            HashSet<File> sources = new HashSet<File>();
            String resourceDir = (String)it.next();
            File dir = new File(basedir, resourceDir).getAbsoluteFile();
            resourceDir = dir.getPath();
            if (!dir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.addDefaultExcludes();
            scanner.setIncludes(new String[]{"**/*" + scriptFileExtension});
            scanner.scan();
            String[] relativePaths = scanner.getIncludedFiles();
            for (int i = 0; i < relativePaths.length; ++i) {
                String relativePath = relativePaths[i];
                File scriptFile = new File(dir, relativePath).getAbsoluteFile();
                if (!scriptFile.isFile() || !relativePath.endsWith(scriptFileExtension)) continue;
                sources.add(scriptFile);
            }
            sourcesByBasedir.put(resourceDir, sources);
        }
        return sourcesByBasedir;
    }

    protected List extractMojoDescriptorsFromMetadata(Map metadataFilesKeyedByBasedir, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        return null;
    }

    protected String getMetadataFileExtension() {
        return null;
    }

    protected List extractMojoDescriptors(Map scriptFilesKeyedByBasedir, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        return null;
    }

    protected abstract String getScriptFileExtension();
}

