/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.antrun;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

class AntrunXmlPlexusConfigurationWriter {
    private static final Set<String> EXCLUDED_ATTRIBUTES = new HashSet<String>(Arrays.asList("combine.children", "combine.self"));

    AntrunXmlPlexusConfigurationWriter() {
    }

    public void write(PlexusConfiguration configuration, File file, String customTaskPrefix, String antTargetName) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)System.getProperty("line.separator"));
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            serializer.setOutput((OutputStream)bos, "UTF-8");
            serializer.startDocument("UTF-8", null);
            if (!customTaskPrefix.isEmpty()) {
                serializer.setPrefix(customTaskPrefix, "antlib:org.apache.maven.ant.tasks");
            }
            serializer.startTag(null, "project");
            serializer.attribute(null, "name", "maven-antrun-");
            serializer.attribute(null, "default", antTargetName);
            this.write(configuration, (XmlSerializer)serializer);
            serializer.endTag(null, "project");
            serializer.endDocument();
        }
    }

    private void write(PlexusConfiguration c, XmlSerializer serializer) throws IOException {
        serializer.startTag(null, c.getName());
        this.writeAttributes(c, serializer);
        int count = c.getChildCount();
        if (count == 0) {
            String value = c.getValue();
            if (value != null) {
                serializer.text(value);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                PlexusConfiguration child = c.getChild(i);
                this.write(child, serializer);
            }
        }
        serializer.endTag(null, c.getName());
    }

    private void writeAttributes(PlexusConfiguration c, XmlSerializer serializer) throws IOException {
        String[] names;
        for (String name : names = c.getAttributeNames()) {
            if (EXCLUDED_ATTRIBUTES.contains(name)) continue;
            serializer.attribute(null, name, c.getAttribute(name));
        }
    }
}

