/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.wrappers.RepoBuilderConfigSourceWrapper;
import org.apache.maven.plugin.assembly.archive.phase.wrappers.RepoInfoWrapper;
import org.apache.maven.plugin.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.shared.repository.RepositoryAssembler;
import org.apache.maven.shared.repository.RepositoryAssemblyException;
import org.apache.maven.shared.repository.RepositoryBuilderConfigSource;
import org.apache.maven.shared.repository.model.RepositoryInfo;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class RepositoryAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    private RepositoryAssembler repositoryAssembler;

    public RepositoryAssemblyPhase() {
    }

    public RepositoryAssemblyPhase(RepositoryAssembler repositoryAssembler) {
        this.repositoryAssembler = repositoryAssembler;
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List repositoriesList = assembly.getRepositories();
        File tempRoot = configSource.getTemporaryRootDirectory();
        Iterator i = repositoriesList.iterator();
        while (i.hasNext()) {
            Repository repository = (Repository)i.next();
            File repositoryDirectory = new File(tempRoot, repository.getOutputDirectory());
            if (!repositoryDirectory.exists()) {
                repositoryDirectory.mkdirs();
            }
            try {
                this.repositoryAssembler.buildRemoteRepository(repositoryDirectory, this.wrap(repository), this.wrap(configSource));
            }
            catch (RepositoryAssemblyException e) {
                throw new ArchiveCreationException("Failed to assembly repository: " + e.getMessage(), e);
            }
            String outputDirectory = AssemblyFormatUtils.getOutputDirectory(repository.getOutputDirectory(), configSource.getProject(), configSource.getFinalName());
            AddDirectoryTask task = new AddDirectoryTask(repositoryDirectory);
            task.setDirectoryMode(TypeConversionUtils.modeToInt(repository.getDirectoryMode(), this.getLogger()));
            task.setFileMode(TypeConversionUtils.modeToInt(repository.getFileMode(), this.getLogger()));
            task.setUseDefaultExcludes(repository.isUseDefaultExcludes());
            task.setOutputDirectory(outputDirectory);
            task.execute(archiver, configSource);
        }
    }

    private RepositoryBuilderConfigSource wrap(AssemblerConfigurationSource configSource) {
        return new RepoBuilderConfigSourceWrapper(configSource);
    }

    private RepositoryInfo wrap(Repository repository) {
        return new RepoInfoWrapper(repository);
    }
}

