/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugin.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultAssemblyReader
extends AbstractLogEnabled
implements AssemblyReader {
    public List readAssemblies(AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        int i;
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        File descriptor = configSource.getDescriptor();
        String descriptorId = configSource.getDescriptorId();
        File[] descriptors = configSource.getDescriptors();
        String[] descriptorRefs = configSource.getDescriptorReferences();
        File descriptorSourceDirectory = configSource.getDescriptorSourceDirectory();
        if (descriptor != null) {
            assemblies.add(this.getAssemblyFromDescriptorFile(descriptor, configSource));
        }
        if (descriptorId != null) {
            assemblies.add(this.getAssemblyForDescriptorReference(descriptorId, configSource));
        }
        if (descriptors != null && descriptors.length > 0) {
            for (i = 0; i < descriptors.length; ++i) {
                this.getLogger().info("Reading assembly descriptor: " + descriptors[i]);
                assemblies.add(this.getAssemblyFromDescriptorFile(descriptors[i], configSource));
            }
        }
        if (descriptorRefs != null && descriptorRefs.length > 0) {
            for (i = 0; i < descriptorRefs.length; ++i) {
                assemblies.add(this.getAssemblyForDescriptorReference(descriptorRefs[i], configSource));
            }
        }
        if (descriptorSourceDirectory != null && descriptorSourceDirectory.isDirectory()) {
            try {
                List descriptorList;
                try {
                    descriptorList = FileUtils.getFiles((File)descriptorSourceDirectory, (String)"**/*.xml", null);
                }
                catch (NullPointerException e) {
                    StackTraceElement frameZero = e.getStackTrace()[0];
                    if ("org.codehaus.plexus.util.DirectoryScanner".equals(frameZero.getClassName()) && "scandir".equals(frameZero.getMethodName())) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Caught filesystem error while scanning directories...using zero-length list as the result.", (Throwable)e);
                        }
                        descriptorList = Collections.EMPTY_LIST;
                    }
                    throw e;
                }
                Iterator iter = descriptorList.iterator();
                while (iter.hasNext()) {
                    assemblies.add(this.getAssemblyFromDescriptorFile((File)iter.next(), configSource));
                }
            }
            catch (IOException e) {
                throw new AssemblyReadException("error discovering descriptor files: " + e.getMessage());
            }
        }
        if (assemblies.isEmpty()) {
            throw new AssemblyReadException("No assembly descriptors found.");
        }
        HashSet<String> ids = new HashSet<String>();
        Iterator i2 = assemblies.iterator();
        while (i2.hasNext()) {
            Assembly assembly = (Assembly)i2.next();
            if (ids.add(assembly.getId())) continue;
            this.getLogger().warn("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    public Assembly getAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            throw new AssemblyReadException("Descriptor with ID '" + ref + "' not found");
        }
        return this.readAssembly(new InputStreamReader(resourceAsStream), ref, configSource);
    }

    public Assembly getAssemblyFromDescriptorFile(File file, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        FileReader r = null;
        try {
            r = new FileReader(file);
            assembly = this.readAssembly(r, file.getAbsolutePath(), configSource);
        }
        catch (FileNotFoundException e) {
            try {
                throw new AssemblyReadException("Error locating assembly descriptor file: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return assembly;
    }

    public Assembly readAssembly(Reader reader, String locationDescription, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        File basedir = configSource.getBasedir();
        MavenProject project = configSource.getProject();
        try {
            HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
            context.put("basedir", basedir.getAbsolutePath());
            AssemblyXpp3Reader r = new AssemblyXpp3Reader();
            assembly = r.read(reader);
            assembly = new AssemblyInterpolator().interpolate(assembly, project, context);
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (AssemblyInterpolationException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (configSource.isSiteIncluded() || assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly, configSource);
        }
        this.mergeComponentsWithMainAssembly(assembly, configSource);
        return assembly;
    }

    protected void mergeComponentsWithMainAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws AssemblyReadException {
        List componentDescriptorFiles = assembly.getComponentDescriptors();
        for (int i = 0; i < componentDescriptorFiles.size(); ++i) {
            Component component = this.getComponentFromFile(componentDescriptorFiles.get(i).toString(), configSource);
            this.mergeComponentWithAssembly(component, assembly);
        }
    }

    protected void mergeComponentWithAssembly(Component component, Assembly assembly) {
        List dependencySetList = component.getDependencySets();
        Iterator it = dependencySetList.iterator();
        while (it.hasNext()) {
            DependencySet dependencySet = (DependencySet)it.next();
            assembly.addDependencySet(dependencySet);
        }
        List fileSetList = component.getFileSets();
        Iterator it2 = fileSetList.iterator();
        while (it2.hasNext()) {
            FileSet fileSet = (FileSet)it2.next();
            assembly.addFileSet(fileSet);
        }
        List fileList = component.getFiles();
        Iterator it3 = fileList.iterator();
        while (it3.hasNext()) {
            FileItem fileItem = (FileItem)it3.next();
            assembly.addFile(fileItem);
        }
        List repositoriesList = component.getRepositories();
        Iterator it4 = repositoriesList.iterator();
        while (it4.hasNext()) {
            Repository repository = (Repository)it4.next();
            assembly.addRepository(repository);
        }
    }

    protected Component getComponentFromFile(String filePath, AssemblerConfigurationSource configSource) throws AssemblyReadException {
        FileReader r;
        File basedir = configSource.getBasedir();
        File componentDescriptor = new File(basedir, filePath);
        try {
            r = new FileReader(componentDescriptor);
        }
        catch (FileNotFoundException e) {
            throw new AssemblyReadException("Unable to find descriptor: " + e.getMessage());
        }
        return this.readComponent(r);
    }

    protected Component readComponent(Reader reader) throws AssemblyReadException {
        Component component;
        try {
            ComponentXpp3Reader r = new ComponentXpp3Reader();
            component = r.read(reader);
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading component descriptor", e);
        }
        catch (XmlPullParserException e) {
            throw new AssemblyReadException("Error reading component descriptor", e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return component;
    }

    public void includeSiteInAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        File siteDirectory = configSource.getSiteDirectory();
        if (!siteDirectory.exists()) {
            throw new InvalidAssemblerConfigurationException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLogger().info("Adding site directory to assembly : " + siteDirectory);
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "assemblyReader-internal");
            this.enableLogging(logger);
        }
        return logger;
    }
}

