/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.SetBase;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ComponentXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, Component component) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(component.getModelEncoding(), null);
        this.writeComponent(component, "component", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeComponent(Component component, String tagName, XmlSerializer serializer) throws IOException {
        if (component != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (component.getFileSets() != null && component.getFileSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "fileSets");
                iter = component.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "fileSets");
            }
            if (component.getFiles() != null && component.getFiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "files");
                iter = component.getFiles().iterator();
                while (iter.hasNext()) {
                    o = (FileItem)iter.next();
                    this.writeFileItem((FileItem)o, "file", serializer);
                }
                serializer.endTag(this.NAMESPACE, "files");
            }
            if (component.getDependencySets() != null && component.getDependencySets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencySets");
                iter = component.getDependencySets().iterator();
                while (iter.hasNext()) {
                    o = (DependencySet)iter.next();
                    this.writeDependencySet((DependencySet)o, "dependencySet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencySets");
            }
            if (component.getRepositories() != null && component.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = component.getRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer) throws IOException {
        if (dependencySet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals("${artifactId}-${version}.${extension}")) {
                serializer.startTag(this.NAMESPACE, "outputFileNameMapping").text(dependencySet.getOutputFileNameMapping()).endTag(this.NAMESPACE, "outputFileNameMapping");
            }
            if (dependencySet.isUnpack()) {
                serializer.startTag(this.NAMESPACE, "unpack").text(String.valueOf(dependencySet.isUnpack())).endTag(this.NAMESPACE, "unpack");
            }
            if (dependencySet.getUnpackOptions() != null) {
                this.writeUnpackOptions(dependencySet.getUnpackOptions(), "unpackOptions", serializer);
            }
            if (dependencySet.getScope() != null && !dependencySet.getScope().equals("runtime")) {
                serializer.startTag(this.NAMESPACE, "scope").text(dependencySet.getScope()).endTag(this.NAMESPACE, "scope");
            }
            if (dependencySet.isUseTransitiveFiltering()) {
                serializer.startTag(this.NAMESPACE, "useTransitiveFiltering").text(String.valueOf(dependencySet.isUseTransitiveFiltering())).endTag(this.NAMESPACE, "useTransitiveFiltering");
            }
            if (dependencySet.isUseStrictFiltering()) {
                serializer.startTag(this.NAMESPACE, "useStrictFiltering").text(String.valueOf(dependencySet.isUseStrictFiltering())).endTag(this.NAMESPACE, "useStrictFiltering");
            }
            if (!dependencySet.isUseDefaultExcludes()) {
                serializer.startTag(this.NAMESPACE, "useDefaultExcludes").text(String.valueOf(dependencySet.isUseDefaultExcludes())).endTag(this.NAMESPACE, "useDefaultExcludes");
            }
            if (dependencySet.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(dependencySet.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = dependencySet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = dependencySet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (dependencySet.getFileMode() != null && !dependencySet.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(dependencySet.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (dependencySet.getDirectoryMode() != null && !dependencySet.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(dependencySet.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileItem(FileItem fileItem, String tagName, XmlSerializer serializer) throws IOException {
        if (fileItem != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileItem.getSource() != null) {
                serializer.startTag(this.NAMESPACE, "source").text(fileItem.getSource()).endTag(this.NAMESPACE, "source");
            }
            if (fileItem.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(fileItem.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (fileItem.getDestName() != null) {
                serializer.startTag(this.NAMESPACE, "destName").text(fileItem.getDestName()).endTag(this.NAMESPACE, "destName");
            }
            if (fileItem.getFileMode() != null && !fileItem.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(fileItem.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (fileItem.getLineEnding() != null) {
                serializer.startTag(this.NAMESPACE, "lineEnding").text(fileItem.getLineEnding()).endTag(this.NAMESPACE, "lineEnding");
            }
            if (fileItem.isFiltered()) {
                serializer.startTag(this.NAMESPACE, "filtered").text(String.valueOf(fileItem.isFiltered())).endTag(this.NAMESPACE, "filtered");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getLineEnding() != null) {
                serializer.startTag(this.NAMESPACE, "lineEnding").text(fileSet.getLineEnding()).endTag(this.NAMESPACE, "lineEnding");
            }
            if (fileSet.isFiltered()) {
                serializer.startTag(this.NAMESPACE, "filtered").text(String.valueOf(fileSet.isFiltered())).endTag(this.NAMESPACE, "filtered");
            }
            if (fileSet.isUseStrictFiltering()) {
                serializer.startTag(this.NAMESPACE, "useStrictFiltering").text(String.valueOf(fileSet.isUseStrictFiltering())).endTag(this.NAMESPACE, "useStrictFiltering");
            }
            if (!fileSet.isUseDefaultExcludes()) {
                serializer.startTag(this.NAMESPACE, "useDefaultExcludes").text(String.valueOf(fileSet.isUseDefaultExcludes())).endTag(this.NAMESPACE, "useDefaultExcludes");
            }
            if (fileSet.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(fileSet.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (fileSet.getFileMode() != null && !fileSet.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(fileSet.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(fileSet.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment, String tagName, XmlSerializer serializer) throws IOException {
        if (groupVersionAlignment != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (groupVersionAlignment.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(groupVersionAlignment.getId()).endTag(this.NAMESPACE, "id");
            }
            if (groupVersionAlignment.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(groupVersionAlignment.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (groupVersionAlignment.getExcludes() != null && groupVersionAlignment.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                Iterator iter = groupVersionAlignment.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.isIncludeMetadata()) {
                serializer.startTag(this.NAMESPACE, "includeMetadata").text(String.valueOf(repository.isIncludeMetadata())).endTag(this.NAMESPACE, "includeMetadata");
            }
            if (repository.getGroupVersionAlignments() != null && repository.getGroupVersionAlignments().size() > 0) {
                serializer.startTag(this.NAMESPACE, "groupVersionAlignments");
                iter = repository.getGroupVersionAlignments().iterator();
                while (iter.hasNext()) {
                    GroupVersionAlignment o = (GroupVersionAlignment)iter.next();
                    this.writeGroupVersionAlignment(o, "groupVersionAlignment", serializer);
                }
                serializer.endTag(this.NAMESPACE, "groupVersionAlignments");
            }
            if (repository.getScope() != null && !repository.getScope().equals("runtime")) {
                serializer.startTag(this.NAMESPACE, "scope").text(repository.getScope()).endTag(this.NAMESPACE, "scope");
            }
            if (repository.isUseStrictFiltering()) {
                serializer.startTag(this.NAMESPACE, "useStrictFiltering").text(String.valueOf(repository.isUseStrictFiltering())).endTag(this.NAMESPACE, "useStrictFiltering");
            }
            if (!repository.isUseDefaultExcludes()) {
                serializer.startTag(this.NAMESPACE, "useDefaultExcludes").text(String.valueOf(repository.isUseDefaultExcludes())).endTag(this.NAMESPACE, "useDefaultExcludes");
            }
            if (repository.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(repository.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (repository.getIncludes() != null && repository.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = repository.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (repository.getExcludes() != null && repository.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = repository.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (repository.getFileMode() != null && !repository.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(repository.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (repository.getDirectoryMode() != null && !repository.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(repository.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer) throws IOException {
        if (setBase != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (setBase.isUseStrictFiltering()) {
                serializer.startTag(this.NAMESPACE, "useStrictFiltering").text(String.valueOf(setBase.isUseStrictFiltering())).endTag(this.NAMESPACE, "useStrictFiltering");
            }
            if (!setBase.isUseDefaultExcludes()) {
                serializer.startTag(this.NAMESPACE, "useDefaultExcludes").text(String.valueOf(setBase.isUseDefaultExcludes())).endTag(this.NAMESPACE, "useDefaultExcludes");
            }
            if (setBase.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(setBase.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (setBase.getIncludes() != null && setBase.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = setBase.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (setBase.getExcludes() != null && setBase.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = setBase.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (setBase.getFileMode() != null && !setBase.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(setBase.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(setBase.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeUnpackOptions(UnpackOptions unpackOptions, String tagName, XmlSerializer serializer) throws IOException {
        if (unpackOptions != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (unpackOptions.getIncludes() != null && unpackOptions.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = unpackOptions.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (unpackOptions.getExcludes() != null && unpackOptions.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = unpackOptions.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (unpackOptions.isFiltered()) {
                serializer.startTag(this.NAMESPACE, "filtered").text(String.valueOf(unpackOptions.isFiltered())).endTag(this.NAMESPACE, "filtered");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

