/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.archive.ManifestCreationFinalizer;
import org.apache.maven.plugin.assembly.archive.archiver.AssemblyProxyArchiver;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhaseComparator;
import org.apache.maven.plugin.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugin.assembly.filter.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.diags.DryRunArchiver;
import org.codehaus.plexus.archiver.filters.JarSecurityFileSelector;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.archiver.zip.AbstractZipArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AssemblyArchiver.class)
public class DefaultAssemblyArchiver
extends AbstractLogEnabled
implements AssemblyArchiver,
Contextualizable {
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement(role=AssemblyArchiverPhase.class)
    private List<AssemblyArchiverPhase> assemblyPhases;
    @Requirement(role=ContainerDescriptorHandler.class)
    private Map<String, ContainerDescriptorHandler> containerDescriptorHandlers;
    private PlexusContainer container;

    public DefaultAssemblyArchiver() {
    }

    protected DefaultAssemblyArchiver(ArchiverManager archiverManager, List<AssemblyArchiverPhase> assemblyPhases) {
        this.archiverManager = archiverManager;
        this.assemblyPhases = assemblyPhases;
    }

    private List<AssemblyArchiverPhase> sortedPhases() {
        ArrayList<AssemblyArchiverPhase> sorted = new ArrayList<AssemblyArchiverPhase>(this.assemblyPhases);
        Collections.sort(sorted, new AssemblyArchiverPhaseComparator());
        return sorted;
    }

    @Override
    public File createArchive(Assembly assembly, String fullName, String format, AssemblerConfigurationSource configSource, boolean recompressZippedFiles) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        this.validate(assembly);
        String filename = fullName;
        if (!configSource.isIgnoreDirFormatExtensions() || !format.startsWith("dir")) {
            filename = filename + "." + format;
        }
        AssemblyFileUtils.verifyTempDirectoryAvailability(configSource.getTemporaryRootDirectory());
        File outputDirectory = configSource.getOutputDirectory();
        File destFile = new File(outputDirectory, filename);
        try {
            String finalName = configSource.getFinalName();
            String specifiedBasedir = assembly.getBaseDirectory();
            String basedir = finalName;
            if (specifiedBasedir != null) {
                basedir = AssemblyFormatUtils.getOutputDirectory(specifiedBasedir, finalName, configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null));
            }
            List<ContainerDescriptorHandler> containerHandlers = this.selectContainerDescriptorHandlers(assembly.getContainerDescriptorHandlers(), configSource);
            Archiver archiver = this.createArchiver(format, assembly.isIncludeBaseDirectory(), basedir, configSource, containerHandlers, recompressZippedFiles);
            archiver.setDestFile(destFile);
            for (AssemblyArchiverPhase phase : this.sortedPhases()) {
                phase.execute(assembly, archiver, configSource);
            }
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiveCreationException("Unable to obtain archiver for extension '" + format + "', for assembly: '" + assembly.getId() + "'", e);
        }
        catch (DependencyResolutionException e) {
            throw new ArchiveCreationException("Unable to resolve dependencies for assembly '" + assembly.getId() + "'", e);
        }
        return destFile;
    }

    private void validate(Assembly assembly) throws InvalidAssemblerConfigurationException {
        if (assembly.getId() == null || assembly.getId().trim().length() < 1) {
            throw new InvalidAssemblerConfigurationException("Assembly ID must be present and non-empty.");
        }
    }

    private List<ContainerDescriptorHandler> selectContainerDescriptorHandlers(List<ContainerDescriptorHandlerConfig> requestedContainerDescriptorHandlers, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        this.getLogger().debug("All known ContainerDescriptorHandler components: " + (this.containerDescriptorHandlers == null ? "none; map is null." : "" + this.containerDescriptorHandlers.keySet()));
        if (requestedContainerDescriptorHandlers == null) {
            requestedContainerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
        }
        ArrayList<ContainerDescriptorHandler> handlers = new ArrayList<ContainerDescriptorHandler>();
        ArrayList<String> hints = new ArrayList<String>();
        if (!requestedContainerDescriptorHandlers.isEmpty()) {
            for (ContainerDescriptorHandlerConfig config : requestedContainerDescriptorHandlers) {
                String hint = config.getHandlerName();
                ContainerDescriptorHandler handler = this.containerDescriptorHandlers.get(hint);
                if (handler == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find ContainerDescriptorHandler with hint: " + hint);
                }
                this.getLogger().debug("Found container descriptor handler with hint: " + hint + " (component: " + handler + ")");
                if (config.getConfiguration() != null) {
                    this.getLogger().debug("Configuring handler with:\n\n" + config.getConfiguration() + "\n\n");
                    this.configureContainerDescriptorHandler(handler, (Xpp3Dom)config.getConfiguration(), configSource);
                }
                handlers.add(handler);
                hints.add(hint);
            }
        }
        if (!hints.contains("plexus")) {
            handlers.add(new ComponentsXmlArchiverFileFilter());
        }
        return handlers;
    }

    protected Archiver createArchiver(String format, boolean includeBaseDir, String finalName, AssemblerConfigurationSource configSource, List<ContainerDescriptorHandler> containerHandlers, boolean recompressZippedFiles) throws NoSuchArchiverException {
        Archiver archiver = "tgz".equals(format) || "tbz2".equals(format) || format.startsWith("tar") ? this.createTarArchiver(format, TarLongFileMode.valueOf((String)configSource.getTarLongFileMode())) : ("war".equals(format) ? this.createWarArchiver() : this.archiverManager.getArchiver(format));
        if (archiver instanceof AbstractZipArchiver) {
            ((AbstractZipArchiver)archiver).setRecompressAddedZips(recompressZippedFiles);
        }
        ArrayList<FileSelector> extraSelectors = new ArrayList<FileSelector>();
        ArrayList<ArchiveFinalizer> extraFinalizers = new ArrayList<ArchiveFinalizer>();
        if (archiver instanceof JarArchiver) {
            extraSelectors.add((FileSelector)new JarSecurityFileSelector());
            extraFinalizers.add((ArchiveFinalizer)new ManifestCreationFinalizer(configSource.getMavenSession(), configSource.getProject(), configSource.getJarArchiveConfiguration()));
        }
        if (configSource.getArchiverConfig() != null) {
            this.configureArchiver(archiver, configSource);
        }
        String prefix = "";
        if (includeBaseDir) {
            prefix = finalName;
        }
        archiver = new AssemblyProxyArchiver(prefix, archiver, containerHandlers, extraSelectors, extraFinalizers, configSource.getWorkingDirectory(), this.getLogger());
        if (configSource.isDryRun()) {
            archiver = new DryRunArchiver(archiver, this.getLogger());
        }
        archiver.setUseJvmChmod(configSource.isUpdateOnly());
        archiver.setIgnorePermissions(configSource.isIgnorePermissions());
        archiver.setForced(!configSource.isUpdateOnly());
        return archiver;
    }

    private void configureContainerDescriptorHandler(ContainerDescriptorHandler handler, Xpp3Dom config, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        this.getLogger().debug("Configuring handler: '" + handler.getClass().getName() + "' -->");
        try {
            this.configureComponent(handler, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new InvalidAssemblerConfigurationException("Failed to configure handler: " + handler.getClass().getName(), e);
        }
        catch (ComponentLookupException e) {
            throw new InvalidAssemblerConfigurationException("Failed to lookup configurator for setup of handler: " + handler.getClass().getName(), e);
        }
        this.getLogger().debug("-- end configuration --");
    }

    private void configureArchiver(Archiver archiver, AssemblerConfigurationSource configSource) {
        Xpp3Dom config;
        try {
            config = Xpp3DomBuilder.build((Reader)new StringReader(configSource.getArchiverConfig()));
        }
        catch (XmlPullParserException e) {
            throw new ArchiverException("Failed to parse archiver configuration for: " + archiver.getClass().getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to parse archiver configuration for: " + archiver.getClass().getName(), (Throwable)e);
        }
        this.getLogger().debug("Configuring archiver: '" + archiver.getClass().getName() + "' -->");
        try {
            this.configureComponent(archiver, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new ArchiverException("Failed to configure archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        catch (ComponentLookupException e) {
            throw new ArchiverException("Failed to lookup configurator for setup of archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        this.getLogger().debug("-- end configuration --");
    }

    private void configureComponent(Object component, Xpp3Dom config, AssemblerConfigurationSource configSource) throws ComponentLookupException, ComponentConfigurationException {
        ComponentConfigurator configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.ROLE, "basic");
        DebugConfigurationListener listener = new DebugConfigurationListener(this.getLogger());
        AssemblyExpressionEvaluator expressionEvaluator = new AssemblyExpressionEvaluator(configSource);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(config);
        Object[] containerRealm = this.getContainerRealm();
        try {
            Method configureComponent = ComponentConfigurator.class.getMethod("configureComponent", Object.class, PlexusConfiguration.class, ExpressionEvaluator.class, (Class)containerRealm[1], ConfigurationListener.class);
            configureComponent.invoke((Object)configurator, component, configuration, expressionEvaluator, containerRealm[0], listener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ComponentConfigurationException) {
                throw (ComponentConfigurationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Object[] getContainerRealm() {
        try {
            Method getContainerRealm = this.container.getClass().getMethod("getContainerRealm", new Class[0]);
            return new Object[]{getContainerRealm.invoke((Object)this.container, new Object[0]), getContainerRealm.getReturnType()};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected Archiver createWarArchiver() throws NoSuchArchiverException {
        WarArchiver warArchiver = (WarArchiver)this.archiverManager.getArchiver("war");
        warArchiver.setIgnoreWebxml(false);
        return warArchiver;
    }

    protected Archiver createTarArchiver(String format, TarLongFileMode tarLongFileMode) throws NoSuchArchiverException {
        TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        int index = format.indexOf(46);
        if (index >= 0) {
            TarArchiver.TarCompressionMethod tarCompressionMethod;
            String compression = format.substring(index + 1);
            if ("gz".equals(compression)) {
                tarCompressionMethod = TarArchiver.TarCompressionMethod.gzip;
            } else if ("bz2".equals(compression)) {
                tarCompressionMethod = TarArchiver.TarCompressionMethod.bzip2;
            } else if ("snappy".equals(compression)) {
                tarCompressionMethod = TarArchiver.TarCompressionMethod.snappy;
            } else {
                throw new IllegalArgumentException("Unknown compression format: " + compression);
            }
            tarArchiver.setCompression(tarCompressionMethod);
        } else if ("tgz".equals(format)) {
            tarArchiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
        } else if ("tbz2".equals(format)) {
            tarArchiver.setCompression(TarArchiver.TarCompressionMethod.bzip2);
        }
        tarArchiver.setLongfile(tarLongFileMode);
        return tarArchiver;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void setContainer(PlexusContainer container) {
        this.container = container;
    }
}

