/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.utils.LineEndings;
import org.apache.maven.plugins.assembly.utils.LinuxLineFeedInputStream;
import org.apache.maven.plugins.assembly.utils.WindowsLineFeedInputStream;

public final class LineEndingsUtils {
    private LineEndingsUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static void convertLineEndings(File source, File dest, LineEndings lineEndings, Boolean atEndOfFile, String encoding) throws IOException {
        eofChars = "";
        if (atEndOfFile == null) {
            if (source.length() >= 1L) {
                raf = new RandomAccessFile(source, "r");
                try {
                    raf.seek(source.length() - 1L);
                    last = raf.readByte();
                    if (last != 10) ** GOTO lbl17
                    eofChars = lineEndings.getLineEndingCharacters();
                }
                finally {
                    raf.close();
                }
            }
        } else if (atEndOfFile.booleanValue()) {
            eofChars = lineEndings.getLineEndingCharacters();
        }
lbl17:
        // 6 sources

        in = LineEndingsUtils.getBufferedReader(source, encoding);
        try {
            out = LineEndingsUtils.getBufferedWriter(dest, encoding);
            try {
                line = in.readLine();
                while (line != null) {
                    out.write(line);
                    line = in.readLine();
                    if (line != null) {
                        out.write(lineEndings.getLineEndingCharacters());
                        continue;
                    }
                    out.write(eofChars);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static BufferedReader getBufferedReader(File source, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(Files.newInputStream(source.toPath(), new OpenOption[0])));
        }
        return new BufferedReader(new InputStreamReader(Files.newInputStream(source.toPath(), new OpenOption[0]), encoding));
    }

    private static BufferedWriter getBufferedWriter(File dest, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dest.toPath(), new OpenOption[0])));
        }
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dest.toPath(), new OpenOption[0]), encoding));
    }

    public static InputStream lineEndingConverter(InputStream in, LineEndings lineEndings) throws IOException {
        return lineEndings.isNewLine() ? new LinuxLineFeedInputStream(in, false) : (lineEndings.isCrLF() ? new WindowsLineFeedInputStream(in, false) : in);
    }

    public static LineEndings getLineEnding(String lineEnding) throws AssemblyFormattingException {
        LineEndings result = LineEndings.keep;
        if (lineEnding != null) {
            try {
                result = LineEndings.valueOf(lineEnding);
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return result;
    }

    public static String getLineEndingCharacters(String lineEnding) throws AssemblyFormattingException {
        String value = lineEnding;
        if (lineEnding != null) {
            try {
                value = LineEndings.valueOf(lineEnding).getLineEndingCharacters();
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return value;
    }
}

