/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.exclusion;

import java.lang.reflect.Proxy;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;

class Coordinates
implements Comparable<Coordinates> {
    private final String groupId;
    private final String artifactId;
    private final Dependency dependency;
    private final InputLocation location;

    private Coordinates(String groupId, String artifactId, Dependency dependency, InputLocation location) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.dependency = dependency;
        this.location = location;
    }

    public static Coordinates coordinates(String groupId, String artifactId) {
        return new Coordinates(groupId, artifactId, null, null);
    }

    public static Coordinates coordinates(Dependency dependency) {
        return new Coordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency, null);
    }

    public static Coordinates coordinates(Exclusion exclusion) {
        return new Coordinates(exclusion.getGroupId(), exclusion.getArtifactId(), null, exclusion.getLocation((Object)""));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    Predicate<Coordinates> getExclusionPattern() {
        PathMatcher groupId = FileSystems.getDefault().getPathMatcher("glob:" + this.getGroupId());
        PathMatcher artifactId = FileSystems.getDefault().getPathMatcher("glob:" + this.getArtifactId());
        Predicate<Coordinates> predGroupId = a -> groupId.matches(Coordinates.createPathProxy(a.getGroupId()));
        Predicate<Coordinates> predArtifactId = a -> artifactId.matches(Coordinates.createPathProxy(a.getArtifactId()));
        return predGroupId.and(predArtifactId);
    }

    private static Path createPathProxy(String value) {
        return (Path)Proxy.newProxyInstance(Coordinates.class.getClassLoader(), new Class[]{Path.class}, (proxy1, method, args) -> {
            if ("toString".equals(method.getName())) {
                return value;
            }
            throw new UnsupportedOperationException();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.location);
    }

    @Override
    public int compareTo(Coordinates that) {
        if (this.location != null && that.location != null) {
            return this.location.getLineNumber() - that.location.getLineNumber();
        }
        return this.toString().compareTo(that.toString());
    }

    public String toString() {
        String version = "";
        if (this.dependency != null) {
            version = ":" + this.dependency.getVersion();
        }
        String line = "";
        if (this.location != null) {
            line = " @ line: " + this.location.getLineNumber();
        }
        return this.groupId + ":" + this.artifactId + version + line;
    }
}

