/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="deploy-file", requiresProject=false, threadSafe=true)
public class DeployFileMojo
extends AbstractDeployMojo {
    @Component
    private ArtifactDeployer artifactDeployer;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="classifier")
    private String classifier;
    @Deprecated
    @Parameter(property="uniqueVersion")
    private Boolean uniqueVersion;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;
    @Component
    private RepositoryManager repoManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void initProperties() throws MojoExecutionException {
        if (this.pomFile == null) {
            foundPom = false;
            jarFile = null;
            try {
                pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
                jarFile = new JarFile(this.file);
                jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    entry = jarEntries.nextElement();
                    if (!pomEntry.matcher(entry.getName()).matches()) continue;
                    this.getLog().debug((CharSequence)("Using " + entry.getName() + " as pomFile"));
                    foundPom = true;
                    pomInputStream = null;
                    pomOutputStream = null;
                    try {
                        pomInputStream = jarFile.getInputStream(entry);
                        base = this.file.getName();
                        if (base.indexOf(46) > 0) {
                            base = base.substring(0, base.lastIndexOf(46));
                        }
                        this.pomFile = new File(this.file.getParentFile(), base + ".pom");
                        pomOutputStream = new FileOutputStream(this.pomFile);
                        IOUtil.copy((InputStream)pomInputStream, (OutputStream)pomOutputStream);
                        pomOutputStream.close();
                        pomOutputStream = null;
                        pomInputStream.close();
                        pomInputStream = null;
                        this.processModel(this.readModel(this.pomFile));
                    }
                    catch (Throwable var9_12) {
                        IOUtil.close((InputStream)pomInputStream);
                        IOUtil.close(pomOutputStream);
                        throw var9_12;
                    }
                    IOUtil.close((InputStream)pomInputStream);
                    IOUtil.close((OutputStream)pomOutputStream);
                    break;
                }
                if (foundPom) ** GOTO lbl48
                this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
            }
            catch (IOException var3_5) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException var3_4) {}
                }
            }
        } else {
            this.processModel(this.readModel(this.pomFile));
        }
lbl48:
        // 4 sources

        if (this.packaging == null && this.file != null) {
            this.packaging = FileUtils.getExtension((String)this.file.getName());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.uniqueVersion != null) {
            throw new MojoExecutionException("You are using 'uniqueVersion' which has been removed from the maven-deploy-plugin. Please see the >>Major Version Upgrade to version 3.0.0<< on the plugin site.");
        }
        this.failIfOffline();
        if (!this.file.exists()) {
            throw new MojoExecutionException(this.file.getPath() + " not found.");
        }
        this.initProperties();
        ArtifactRepository deploymentRepository = this.createDeploymentArtifactRepository(this.repositoryId, this.url);
        String protocol = deploymentRepository.getProtocol();
        if (StringUtils.isEmpty((String)protocol)) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        MavenProject project = this.createMavenProject();
        Artifact artifact = project.getArtifact();
        if (this.file.equals(this.getLocalRepoFile())) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        ArrayList<Artifact> deployableArtifacts = new ArrayList<Artifact>();
        if (this.classifier == null) {
            artifact.setFile(this.file);
            deployableArtifacts.add(artifact);
        } else {
            this.projectHelper.attachArtifact(project, this.packaging, this.classifier, this.file);
        }
        if (!"pom".equals(this.packaging)) {
            File pom = this.pomFile;
            if (pom == null && this.generatePom) {
                pom = this.generatePomFile();
            }
            if (pom != null) {
                if (this.classifier == null) {
                    ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom);
                    artifact.addMetadata((ArtifactMetadata)metadata);
                } else {
                    artifact.setFile(pom);
                    deployableArtifacts.add(artifact);
                }
            }
        }
        artifact.setRepository(deploymentRepository);
        if (this.sources != null) {
            this.projectHelper.attachArtifact(project, "jar", "sources", this.sources);
        }
        if (this.javadoc != null) {
            this.projectHelper.attachArtifact(project, "jar", "javadoc", this.javadoc);
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = StringUtils.countMatches((String)this.files, (String)",");
            int typesLength = StringUtils.countMatches((String)this.types, (String)",");
            int classifiersLength = StringUtils.countMatches((String)this.classifiers, (String)",");
            if (typesLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                File file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!(file = new File(this.files.substring(fi, nfi))).isFile()) {
                    file = new File(project.getBasedir(), this.files.substring(fi, nfi));
                }
                if (file.isFile()) {
                    if (StringUtils.isWhitespace((String)this.classifiers.substring(ci, nci))) {
                        this.projectHelper.attachArtifact(project, this.types.substring(ti, nti).trim(), file);
                    } else {
                        this.projectHelper.attachArtifact(project, this.types.substring(ti, nti).trim(), this.classifiers.substring(ci, nci).trim(), file);
                    }
                } else {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        List attachedArtifacts = project.getAttachedArtifacts();
        for (Artifact attached : attachedArtifacts) {
            deployableArtifacts.add(attached);
        }
        try {
            this.artifactDeployer.deploy(this.getSession().getProjectBuildingRequest(), deploymentRepository, deployableArtifacts);
        }
        catch (ArtifactDeployerException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private MavenProject createMavenProject() throws MojoExecutionException, MojoFailureException {
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        StringModelSource modelSource = new StringModelSource((CharSequence)("<project><modelVersion>4.0.0</modelVersion><groupId>" + this.groupId + "</groupId><artifactId>" + this.artifactId + "</artifactId><version>" + this.version + "</version><packaging>" + (this.classifier == null ? this.packaging : "pom") + "</packaging></project>"));
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        buildingRequest.setProcessPlugins(false);
        try {
            return this.projectBuilder.build((ModelSource)modelSource, (ProjectBuildingRequest)buildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            if (e.getCause() instanceof ModelBuildingException) {
                throw new MojoExecutionException("The artifact information is not valid:" + Os.LINE_SEP + e.getCause().getMessage());
            }
            throw new MojoFailureException("Unable to create the project.", (Throwable)e);
        }
    }

    private File getLocalRepoFile() {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(this.groupId);
        coordinate.setArtifactId(this.artifactId);
        coordinate.setVersion(this.version);
        coordinate.setClassifier(this.classifier);
        coordinate.setExtension(this.packaging);
        String path = this.repoManager.getPathForLocalArtifact(this.getSession().getProjectBuildingRequest(), (ArtifactCoordinate)coordinate);
        return new File(this.repoManager.getLocalRepositoryBasedir(this.getSession().getProjectBuildingRequest()), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            reader.close();
            reader = null;
            Model model2 = model;
            return model2;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("POM not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            fw.close();
            fw = null;
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    String getPackaging() {
        return this.packaging;
    }

    File getFile() {
        return this.file;
    }

    String getClassifier() {
        return this.classifier;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

