/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.transfer.project.NoFileAssignedException;
import org.apache.maven.shared.transfer.project.deploy.ProjectDeployer;
import org.apache.maven.shared.transfer.project.deploy.ProjectDeployerRequest;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_LEGACY_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+?)::(.+)");
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+)");
    private static final AtomicInteger READYPROJECTSCOUNTER = new AtomicInteger();
    private static final List<ProjectDeployerRequest> DEPLOYREQUESTS = Collections.synchronizedList(new ArrayList());
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false", property="deployAtEnd")
    private boolean deployAtEnd;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(property="maven.deploy.skip", defaultValue="false")
    private String skip = Boolean.FALSE.toString();
    @Component
    private ProjectDeployer projectDeployer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean projectsReady;
        boolean addedDeployRequest = false;
        if (Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !ArtifactUtils.isSnapshot((String)this.project.getVersion()) || "snapshots".equals(this.skip) && ArtifactUtils.isSnapshot((String)this.project.getVersion())) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
        } else {
            this.failIfOffline();
            ProjectDeployerRequest pdr = new ProjectDeployerRequest().setProject(this.project).setRetryFailedDeploymentCount(this.getRetryFailedDeploymentCount()).setAltReleaseDeploymentRepository(this.altReleaseDeploymentRepository).setAltSnapshotDeploymentRepository(this.altSnapshotDeploymentRepository).setAltDeploymentRepository(this.altDeploymentRepository);
            ArtifactRepository repo = this.getDeploymentRepository(pdr);
            if (!this.deployAtEnd) {
                this.deployProject(this.getSession().getProjectBuildingRequest(), pdr, repo);
            } else {
                DEPLOYREQUESTS.add(pdr);
                addedDeployRequest = true;
            }
        }
        boolean bl = projectsReady = READYPROJECTSCOUNTER.incrementAndGet() == this.reactorProjects.size();
        if (projectsReady) {
            List<ProjectDeployerRequest> list = DEPLOYREQUESTS;
            synchronized (list) {
                while (!DEPLOYREQUESTS.isEmpty()) {
                    ArtifactRepository repo = this.getDeploymentRepository(DEPLOYREQUESTS.get(0));
                    this.deployProject(this.getSession().getProjectBuildingRequest(), DEPLOYREQUESTS.remove(0), repo);
                }
            }
        } else if (addedDeployRequest) {
            this.getLog().info((CharSequence)("Deploying " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
        }
    }

    private void deployProject(ProjectBuildingRequest pbr, ProjectDeployerRequest pir, ArtifactRepository repo) throws MojoFailureException, MojoExecutionException {
        try {
            this.projectDeployer.deploy(pbr, pir, repo);
        }
        catch (NoFileAssignedException e) {
            throw new MojoExecutionException("NoFileAssignedException", (Exception)((Object)e));
        }
        catch (ArtifactDeployerException e) {
            throw new MojoExecutionException("ArtifactDeployerException", (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArtifactRepository getDeploymentRepository(ProjectDeployerRequest pdr) throws MojoExecutionException, MojoFailureException {
        MavenProject project = pdr.getProject();
        String altDeploymentRepository = pdr.getAltDeploymentRepository();
        String altReleaseDeploymentRepository = pdr.getAltReleaseDeploymentRepository();
        String altSnapshotDeploymentRepository = pdr.getAltSnapshotDeploymentRepository();
        ArtifactRepository repo = null;
        String altDeploymentRepo = ArtifactUtils.isSnapshot((String)project.getVersion()) && altSnapshotDeploymentRepository != null ? altSnapshotDeploymentRepository : (!ArtifactUtils.isSnapshot((String)project.getVersion()) && altReleaseDeploymentRepository != null ? altReleaseDeploymentRepository : altDeploymentRepository);
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_LEGACY_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (matcher.matches()) {
                String id = matcher.group(1).trim();
                String layout = matcher.group(2).trim();
                String url = matcher.group(3).trim();
                if (!"default".equals(layout)) throw new MojoFailureException((Object)altDeploymentRepo, "Invalid legacy syntax and layout for repository.", "Invalid legacy syntax and layout for alternative repository. Use \"" + id + "::" + url + "\" instead, and only default layout is supported.");
                this.getLog().warn((CharSequence)("Using legacy syntax for alternative repository. Use \"" + id + "::" + url + "\" instead."));
                repo = this.createDeploymentArtifactRepository(id, url);
            } else {
                matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
                if (!matcher.matches()) {
                    throw new MojoFailureException((Object)altDeploymentRepo, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::url\".");
                }
                String id = matcher.group(1).trim();
                String url = matcher.group(2).trim();
                repo = this.createDeploymentArtifactRepository(id, url);
            }
        }
        if (repo == null) {
            repo = project.getDistributionManagementArtifactRepository();
        }
        if (repo != null) return repo;
        String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::url parameter";
        throw new MojoExecutionException(msg);
    }
}

