/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.model.Contributor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ClassMap;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoapUtil {
    private static final String EMAIL_REGEX = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private static final int REPEAT_EQUALS = 21;
    public static final int DEFAULT_TIMEOUT = 2000;
    protected static final String RDF_RESOURCE = "rdf:resource";
    protected static final String RDF_NODE_ID = "rdf:nodeID";
    private static Map<String, Organization> organizations = new HashMap<String, Organization>();
    private static int nodeNumber = 1;

    public static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)(StringUtils.repeat((String)"=", (int)21) + " - DO NOT EDIT THIS FILE! - " + StringUtils.repeat((String)"=", (int)21)));
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"Any modifications will be overwritten.");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Doap Plugin " + DoapUtil.getPluginVersion() + " on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-doap-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    public static void writeComment(XMLWriter writer, String comment) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)comment)) {
            throw new IllegalArgumentException("comment should be defined");
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)comment, (int)2);
    }

    public static void writeElement(XMLWriter writer, String xmlnsPrefix, String name, String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            DoapUtil.writeStartElement(writer, xmlnsPrefix, name);
            writer.writeText(value);
            writer.endElement();
        }
    }

    public static void writeElement(XMLWriter writer, String xmlnsPrefix, String name, String value, String lang) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)lang)) {
            DoapUtil.writeElement(writer, xmlnsPrefix, name, value);
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            DoapUtil.writeStartElement(writer, xmlnsPrefix, name);
            writer.addAttribute("xml:lang", lang);
            writer.writeText(value);
            writer.endElement();
        }
    }

    public static void writeStartElement(XMLWriter writer, String xmlnsPrefix, String name) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (StringUtils.isNotEmpty((String)xmlnsPrefix)) {
            writer.startElement(xmlnsPrefix + ":" + name);
        } else {
            writer.startElement(name);
        }
    }

    public static void writeRdfResourceElement(XMLWriter writer, String xmlnsPrefix, String name, String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            DoapUtil.writeStartElement(writer, xmlnsPrefix, name);
            writer.addAttribute(RDF_RESOURCE, value);
            writer.endElement();
        }
    }

    public static void writeRdfNodeIdElement(XMLWriter writer, String xmlnsPrefix, String name, String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name should be defined");
        }
        if (value != null) {
            DoapUtil.writeStartElement(writer, xmlnsPrefix, name);
            writer.addAttribute(RDF_NODE_ID, value);
            writer.endElement();
        }
    }

    public static List<Contributor> getContributorsWithDeveloperRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("developers");
    }

    public static List<Contributor> getContributorsWithDocumenterRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("documenters");
    }

    public static List<Contributor> getContributorsWithHelperRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("helpers");
    }

    public static List<Contributor> getContributorsWithMaintainerRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("maintainers");
    }

    public static List<Contributor> getContributorsWithTesterRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("testers");
    }

    public static List<Contributor> getContributorsWithTranslatorRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("translators");
    }

    public static List<Contributor> getContributorsWithUnknownRole(I18N i18n, List<Contributor> developersOrContributors) {
        return DoapUtil.filterContributorsByDoapRoles(i18n, developersOrContributors).get("unknowns");
    }

    public static Organization addOrganization(String name, String url) {
        Organization organization = organizations.get(name);
        if (organization == null) {
            organization = new Organization(name, url);
        }
        organizations.put(name, organization);
        return organization;
    }

    public static String getNodeId() {
        return "b" + nodeNumber++;
    }

    public static Set<Map.Entry<String, Organization>> getOrganizations() {
        return organizations.entrySet();
    }

    public static List<String> validate(File doapFile) {
        if (doapFile == null || !doapFile.isFile()) {
            throw new IllegalArgumentException("The DOAP file should exist");
        }
        Model model = ModelFactory.createDefaultModel();
        RDFReader r = model.getReader("RDF/XML");
        r.setProperty("error-mode", (Object)"strict-error");
        final ArrayList<String> errors = new ArrayList<String>();
        r.setErrorHandler((RDFErrorHandler)new RDFDefaultErrorHandler(){

            public void error(Exception e) {
                errors.add(e.getMessage());
            }
        });
        try {
            r.read(model, doapFile.toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return errors;
    }

    public static boolean isValidEmail(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(str);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchURL(Settings settings, URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The url is null");
        }
        if ("file".equals(url.getProtocol())) {
            InputStream in = null;
            try {
                in = url.openStream();
            }
            finally {
                IOUtil.close((InputStream)in);
            }
            return;
        }
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(2000);
        httpClient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        httpClient.getParams().setParameter("http.useragent", (Object)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy activeProxy = settings.getActiveProxy();
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(activeProxy.getNonProxyHosts());
            if (StringUtils.isNotEmpty((String)activeProxy.getHost()) && !ProxyUtils.validateNonProxyHosts((ProxyInfo)proxyInfo, (String)url.getHost())) {
                httpClient.getHostConfiguration().setProxy(activeProxy.getHost(), activeProxy.getPort());
                if (StringUtils.isNotEmpty((String)activeProxy.getUsername()) && activeProxy.getPassword() != null) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(activeProxy.getUsername(), activeProxy.getPassword());
                    httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
        }
        GetMethod getMethod = new GetMethod(url.toString());
        try {
            int status;
            try {
                status = httpClient.executeMethod((HttpMethod)getMethod);
            }
            catch (SocketTimeoutException e) {
                status = httpClient.executeMethod((HttpMethod)getMethod);
            }
            if (status != 200) {
                throw new FileNotFoundException(url.toString());
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public static String interpolate(String value, final MavenProject project, Settings settings) {
        if (project == null) {
            throw new IllegalArgumentException("project is required");
        }
        if (value == null) {
            return value;
        }
        if (!value.contains("${")) {
            return value.trim();
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            // empty catch block
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProperties()));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project", (Object)project));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("pom", (Object)project));
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource(project){

            public Object getValue(String expression) {
                try {
                    return ReflectionValueExtractor.evaluate(expression, project, true);
                }
                catch (Exception e) {
                    this.addFeedback("Failed to extract '" + expression + "' from: " + project, e);
                    return null;
                }
            }
        });
        if (settings != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
        }
        String interpolatedValue = value;
        try {
            interpolatedValue = interpolator.interpolate(value).trim();
        }
        catch (InterpolationException e) {
            // empty catch block
        }
        if (interpolatedValue.startsWith("${")) {
            return null;
        }
        return interpolatedValue;
    }

    private static Map<String, List<Contributor>> filterContributorsByDoapRoles(I18N i18n, List<Contributor> developersOrContributors) {
        HashMap<String, List<Contributor>> returnMap = new HashMap<String, List<Contributor>>(7);
        returnMap.put("maintainers", new ArrayList());
        returnMap.put("developers", new ArrayList());
        returnMap.put("documenters", new ArrayList());
        returnMap.put("translators", new ArrayList());
        returnMap.put("testers", new ArrayList());
        returnMap.put("helpers", new ArrayList());
        returnMap.put("unknowns", new ArrayList());
        if (developersOrContributors == null || developersOrContributors.isEmpty()) {
            return returnMap;
        }
        for (Contributor contributor : developersOrContributors) {
            List roles = contributor.getRoles();
            if (roles != null && roles.size() != 0) {
                for (String role : roles) {
                    if ((role = role.toLowerCase(Locale.ENGLISH)).contains(DoapUtil.getLowerCaseString(i18n, "doap.maintainer"))) {
                        if (((List)returnMap.get("maintainers")).contains(contributor)) continue;
                        ((List)returnMap.get("maintainers")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.developer"))) {
                        if (((List)returnMap.get("developers")).contains(contributor)) continue;
                        ((List)returnMap.get("developers")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.documenter"))) {
                        if (((List)returnMap.get("documenters")).contains(contributor)) continue;
                        ((List)returnMap.get("documenters")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.translator"))) {
                        if (((List)returnMap.get("translators")).contains(contributor)) continue;
                        ((List)returnMap.get("translators")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.tester"))) {
                        if (((List)returnMap.get("testers")).contains(contributor)) continue;
                        ((List)returnMap.get("testers")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.helper"))) {
                        if (((List)returnMap.get("helpers")).contains(contributor)) continue;
                        ((List)returnMap.get("helpers")).add(contributor);
                        continue;
                    }
                    if (role.contains(DoapUtil.getLowerCaseString(i18n, "doap.emeritus")) || ((List)returnMap.get("unknowns")).contains(contributor)) continue;
                    ((List)returnMap.get("unknowns")).add(contributor);
                }
                continue;
            }
            if (((List)returnMap.get("unknowns")).contains(contributor)) continue;
            ((List)returnMap.get("unknowns")).add(contributor);
        }
        return returnMap;
    }

    private static String getLowerCaseString(I18N i18n, String key) {
        return i18n.getString("doap-person", Locale.ENGLISH, key).toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPluginVersion() {
        Properties pomProperties = new Properties();
        InputStream is = null;
        try {
            is = DoapUtil.class.getResourceAsStream("/META-INF/maven/org.apache.maven.plugins/maven-doap-plugin/pom.properties");
            if (is == null) {
                String string = "<unknown>";
                return string;
            }
            pomProperties.load(is);
            String string = pomProperties.getProperty("version", "<unknown>");
            return string;
        }
        catch (IOException e) {
            String string = "<unknown>";
            return string;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionValueExtractor {
        private static final Class[] CLASS_ARGS = new Class[0];
        private static final Object[] OBJECT_ARGS = new Object[0];
        private static final Map<Class, ClassMap> CLASS_MAPS = new WeakHashMap<Class, ClassMap>();

        private ReflectionValueExtractor() {
        }

        public static Object evaluate(String expression, Object root) throws Exception {
            return ReflectionValueExtractor.evaluate(expression, root, true);
        }

        public static Object evaluate(String expression, Object root, boolean trimRootToken) throws Exception {
            if (trimRootToken) {
                expression = expression.substring(expression.indexOf(46) + 1);
            }
            Object value = root;
            StringTokenizer parser = new StringTokenizer(expression, ".");
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                if (value == null) {
                    return null;
                }
                StringTokenizer parser2 = new StringTokenizer(token, "[]");
                int index = -1;
                if (parser2.countTokens() > 1) {
                    token = parser2.nextToken();
                    try {
                        index = Integer.valueOf(parser2.nextToken());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                ClassMap classMap = ReflectionValueExtractor.getClassMap(value.getClass());
                String methodBase = StringUtils.capitalizeFirstLetter((String)token);
                String methodName = "get" + methodBase;
                Method method = classMap.findMethod(methodName, (Object[])CLASS_ARGS);
                if (method == null) {
                    methodName = "is" + methodBase;
                    method = classMap.findMethod(methodName, (Object[])CLASS_ARGS);
                }
                if (method == null) {
                    return null;
                }
                if ((value = method.invoke(value, OBJECT_ARGS)) == null) {
                    return null;
                }
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    ClassMap classMap2 = ReflectionValueExtractor.getClassMap(value.getClass());
                    Method method2 = classMap2.findMethod("toArray", (Object[])CLASS_ARGS);
                    value = method2.invoke(value, OBJECT_ARGS);
                }
                if (!value.getClass().isArray()) continue;
                value = ((Object[])value)[index];
            }
            return value;
        }

        private static ClassMap getClassMap(Class<? extends Object> clazz) {
            ClassMap classMap = CLASS_MAPS.get(clazz);
            if (classMap == null) {
                classMap = new ClassMap(clazz);
                CLASS_MAPS.put(clazz, classMap);
            }
            return classMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Organization {
        private String name;
        private String url;
        private List<String> members = new LinkedList<String>();

        public Organization(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void addMember(String nodeId) {
            this.members.add(nodeId);
        }

        public List<String> getMembers() {
            return this.members;
        }
    }
}

