/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class IdeUtils {
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String JAVA_5_0 = "5.0";
    public static final String JAVA_6_0 = "6.0";
    public static final String PROJECT_NAME_DEFAULT_TEMPLATE = "[artifactId]";
    public static final String PROJECT_NAME_WITH_VERSION_TEMPLATE = "[artifactId]-[version]";
    public static final String PROJECT_NAME_WITH_GROUP_TEMPLATE = "[groupId].[artifactId]";
    public static final String PROJECT_NAME_WITH_GROUP_AND_VERSION_TEMPLATE = "[groupId].[artifactId]-[version]";
    private static final String ARTIFACT_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_TARGET = "target";

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("cantcanonicalize", file.getAbsolutePath()), (Exception)e);
        }
    }

    public static String getCompilerPluginSetting(MavenProject project, String optionName) {
        String value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPlugins(), optionName);
        if (value == null && project.getModel().getBuild().getPluginManagement() != null) {
            value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPluginManagement().getPlugins(), optionName);
        }
        return value;
    }

    public static String getCompilerSourceVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_SOURCE);
    }

    public static String getCompilerTargetVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_TARGET);
    }

    public static String getArtifactVersion(String[] artifactIds, List dependencies, int len) {
        for (int j = 0; j < artifactIds.length; ++j) {
            String id = artifactIds[j];
            Iterator depIter = dependencies.iterator();
            while (depIter.hasNext()) {
                Dependency dep = (Dependency)depIter.next();
                if (!id.equals(dep.getArtifactId())) continue;
                return StringUtils.substring((String)dep.getVersion(), (int)0, (int)len);
            }
        }
        return null;
    }

    public static String getPluginSetting(MavenProject project, String pluginId, String optionName, String defaultValue) {
        Xpp3Dom dom = IdeUtils.getPluginConfigurationDom(project, pluginId);
        if (dom != null && dom.getChild(optionName) != null) {
            return dom.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static Xpp3Dom getPluginConfigurationDom(MavenProject project, String pluginId) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return null;
    }

    public static Xpp3Dom[] getPluginConfigurationDom(MavenProject project, String artifactId, String[] subConfiguration) {
        ArrayList<Xpp3Dom> configurationDomList = new ArrayList<Xpp3Dom>();
        Xpp3Dom configuration = IdeUtils.getPluginConfigurationDom(project, artifactId);
        if (configuration != null) {
            configurationDomList.add(configuration);
            for (int index = 0; !configurationDomList.isEmpty() && subConfiguration != null && index < subConfiguration.length; ++index) {
                ArrayList<Xpp3Dom> newConfigurationDomList = new ArrayList<Xpp3Dom>();
                Iterator childElement = configurationDomList.iterator();
                while (childElement.hasNext()) {
                    Xpp3Dom child = (Xpp3Dom)childElement.next();
                    Xpp3Dom[] deeperChild = child.getChildren(subConfiguration[index]);
                    for (int deeperIndex = 0; deeperIndex < deeperChild.length; ++deeperIndex) {
                        if (deeperChild[deeperIndex] == null) continue;
                        newConfigurationDomList.add(deeperChild[deeperIndex]);
                    }
                }
                configurationDomList = newConfigurationDomList;
            }
        }
        return configurationDomList.toArray(new Xpp3Dom[configurationDomList.size()]);
    }

    protected static String getProjectName(String template, IdeDependency dep) {
        return IdeUtils.getProjectName(template, dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }

    public static String getProjectName(String template, Artifact artifact) {
        return IdeUtils.getProjectName(template, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    public static String getProjectName(String template, MavenProject project) {
        return IdeUtils.getProjectName(template, project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private static String getProjectName(IdeDependency dep, boolean addVersionToProjectName) {
        return IdeUtils.getProjectName(addVersionToProjectName ? PROJECT_NAME_WITH_VERSION_TEMPLATE : PROJECT_NAME_DEFAULT_TEMPLATE, dep);
    }

    public static String getProjectName(MavenProject project, boolean addVersionToProjectName) {
        return IdeUtils.getProjectName(addVersionToProjectName ? PROJECT_NAME_WITH_VERSION_TEMPLATE : PROJECT_NAME_DEFAULT_TEMPLATE, project);
    }

    public static Artifact resolveArtifactWithClassifier(String groupId, String artifactId, String version, String depClassifier, String inClassifier, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteRepos, Log log) {
        String type = null;
        type = "sources".equals(inClassifier) ? "java-source" : inClassifier;
        String finalClassifier = null;
        finalClassifier = depClassifier == null ? inClassifier : ("sources".equals(inClassifier) && "tests".equals(depClassifier) ? "test-sources" : depClassifier + "-" + inClassifier);
        Artifact resolvedArtifact = artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, finalClassifier);
        try {
            artifactResolver.resolve(resolvedArtifact, remoteRepos, localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            String message = Messages.getString("errorresolving", new Object[]{finalClassifier, resolvedArtifact.getId(), e.getMessage()});
            log.warn((CharSequence)message);
        }
        return resolvedArtifact;
    }

    public static String resolveJavaVersion(MavenProject project) {
        String version = IdeUtils.getCompilerTargetVersion(project);
        if (version == null) {
            version = IdeUtils.getCompilerSourceVersion(project);
        }
        if ("1.5".equals(version)) {
            version = JAVA_5_0;
        } else if ("1.6".equals(version)) {
            version = JAVA_6_0;
        } else if (version != null && version.length() == 1) {
            version = version + ".0";
        }
        return version == null ? JAVA_1_4 : version;
    }

    public static String toRelativeAndFixSeparator(File basedir, File fileToAdd, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        if (!fileToAdd.isAbsolute()) {
            fileToAdd = new File(basedir, fileToAdd.getPath());
        }
        String basedirpath = IdeUtils.getCanonicalPath(basedir);
        String absolutePath = IdeUtils.getCanonicalPath(fileToAdd);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (char)'\\', (char)'/');
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }

    private static String findCompilerPluginSettingInPlugins(List plugins, String optionName) {
        String value = null;
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(ARTIFACT_MAVEN_COMPILER_PLUGIN)) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            if (o != null && o.getChild(optionName) != null) {
                value = o.getChild(optionName).getValue();
            }
            List executions = plugin.getExecutions();
            Iterator iter = executions.iterator();
            while (iter.hasNext()) {
                PluginExecution execution = (PluginExecution)iter.next();
                o = (Xpp3Dom)execution.getConfiguration();
                if (o == null || o.getChild(optionName) == null) continue;
                value = o.getChild(optionName).getValue();
            }
        }
        return value;
    }

    private static String getProjectName(String template, String groupId, String artifactId, String version) {
        String s = template;
        s = s.replaceAll("\\[groupId\\]", groupId);
        s = s.replaceAll("\\[artifactId\\]", artifactId);
        s = s.replaceAll("\\[version\\]", version);
        return s;
    }

    private IdeUtils() {
    }
}

