/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class SurefirePlugin
extends AbstractSurefireMojo
implements SurefireReportParameters {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="test")
    private String test;
    @Parameter(property="surefire.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="surefire.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="surefire.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="surefire.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.surefire.debug")
    private String debugForkedProcess;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="surefire.exitTimeout", defaultValue="30")
    private int forkedProcessExitTimeoutInSeconds;
    @Parameter(property="surefire.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="surefire.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter
    private List<String> includes;
    @Parameter(property="surefire.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="surefire.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="surefire.encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private int rerunFailingTestsCount;
    @Parameter(property="surefire.suiteXmlFiles")
    private File[] suiteXmlFiles;
    @Parameter(property="surefire.runOrder", defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="surefire.includesFile")
    private File includesFile;
    @Parameter(property="surefire.excludesFile")
    private File excludesFile;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private int skipAfterFailureCount;
    @Parameter(property="surefire.shutdown", defaultValue="testset")
    private String shutdown;
    @Parameter(property="surefire.useModulePath", defaultValue="true")
    private boolean useModulePath;

    protected int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (PluginConsoleLogger)this.getConsoleLogger(), (Exception)firstForkException);
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "surefire";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/Test*.java", "**/*Test.java", "**/*Tests.java", "**/*TestCase.java"};
    }

    protected String getReportSchemaLocation() {
        return "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report-3.0.xsd";
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        return this.test;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public int getForkedProcessExitTimeoutInSeconds() {
        return this.forkedProcessExitTimeoutInSeconds;
    }

    public void setForkedProcessExitTimeoutInSeconds(int forkedProcessExitTimeoutInSeconds) {
        this.forkedProcessExitTimeoutInSeconds = forkedProcessExitTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public File[] getSuiteXmlFiles() {
        return (File[])this.suiteXmlFiles.clone();
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = (File[])suiteXmlFiles.clone();
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    public File getIncludesFile() {
        return this.includesFile;
    }

    public File getExcludesFile() {
        return this.excludesFile;
    }

    protected boolean useModulePath() {
        return this.useModulePath;
    }

    protected void setUseModulePath(boolean useModulePath) {
        this.useModulePath = useModulePath;
    }

    protected final List<File> suiteXmlFiles() {
        return this.hasSuiteXmlFiles() ? Arrays.asList(this.suiteXmlFiles) : Collections.emptyList();
    }

    protected final boolean hasSuiteXmlFiles() {
        return this.suiteXmlFiles != null && this.suiteXmlFiles.length != 0;
    }
}

