/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.verifier;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.verifier.ConsoleVerificationResultPrinter;
import org.apache.maven.plugin.verifier.VerificationResult;
import org.apache.maven.plugin.verifier.VerificationResultPrinter;
import org.apache.maven.plugin.verifier.model.File;
import org.apache.maven.plugin.verifier.model.Verifications;
import org.apache.maven.plugin.verifier.model.io.xpp3.VerificationsXpp3Reader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class VerifierMojo
extends AbstractMojo {
    private java.io.File basedir;
    private java.io.File verificationFile;
    private boolean failOnError;
    private VerificationResultPrinter resultPrinter = new ConsoleVerificationResultPrinter(this.getLog());

    public void execute() throws MojoExecutionException {
        VerificationResult results = this.verify();
        this.resultPrinter.print(results);
        if (this.failOnError && results.hasFailures()) {
            throw new MojoExecutionException("There are test failures");
        }
    }

    protected java.io.File getAbsoluteFileToCheck(java.io.File file) {
        java.io.File result = file;
        if (!file.isAbsolute()) {
            result = new java.io.File(this.basedir, file.getPath());
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VerificationResult verify() throws MojoExecutionException {
        VerificationResult results = new VerificationResult();
        FileReader reader = null;
        try {
            reader = new FileReader(this.verificationFile);
            VerificationsXpp3Reader xppReader = new VerificationsXpp3Reader();
            Verifications verifications = xppReader.read(reader);
            Iterator i = verifications.getFiles().iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                if (file.getLocation() == null) throw new MojoExecutionException("Missing <location> element");
                file.setLocation(this.getAbsoluteFileToCheck(new java.io.File(file.getLocation())).getPath());
                this.verifyFile(file, results);
            }
        }
        catch (XmlPullParserException e) {
            try {
                throw new MojoExecutionException("Error while verifying files", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("Error while verifying files", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return results;
    }

    private boolean verifyFile(File fileCheck, VerificationResult results) throws IOException {
        boolean result = this.verifyFileExistence(fileCheck, results);
        if (result && fileCheck.getContains() != null) {
            result = result && this.verifyFileContent(fileCheck, results);
        }
        return result;
    }

    private boolean verifyFileContent(File fileCheck, VerificationResult results) throws IOException {
        boolean result = false;
        this.getLog().debug((CharSequence)("Verifying contents of " + fileCheck.getLocation()));
        Pattern pattern = Pattern.compile(fileCheck.getContains());
        Matcher matcher = pattern.matcher(FileUtils.fileRead((java.io.File)new java.io.File(fileCheck.getLocation())));
        if (matcher.find()) {
            result = true;
        } else {
            results.addContentFailure(fileCheck);
        }
        return result;
    }

    private boolean verifyFileExistence(File fileCheck, VerificationResult results) {
        boolean result = false;
        java.io.File physicalFile = new java.io.File(fileCheck.getLocation());
        if (fileCheck.isExists()) {
            this.getLog().debug((CharSequence)("Verifying existence of " + physicalFile));
            result = physicalFile.exists();
            if (!result) {
                results.addExistenceFailure(fileCheck);
            }
        } else {
            this.getLog().debug((CharSequence)("Verifying absence of " + physicalFile));
            boolean bl = result = !physicalFile.exists();
            if (!result) {
                results.addNonExistenceFailure(fileCheck);
            }
        }
        return result;
    }

    public void setBaseDir(java.io.File basedir) {
        this.basedir = basedir;
    }

    public void setVerificationFile(java.io.File file) {
        this.verificationFile = file;
    }

    public void setVerificationResultPrinter(VerificationResultPrinter printer) {
        this.resultPrinter = printer;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

