/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenExecutor
implements MavenExecutor,
LogEnabled {
    private Logger logger;

    protected AbstractMavenExecutor() {
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, (ReleaseEnvironment)new DefaultReleaseEnvironment(), interactive, additionalArguments, pomFileName, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, new DefaultReleaseEnvironment(), interactive, additionalArguments, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String arguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, releaseEnvironment, interactive, arguments, null, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        ArrayList<String> goalsList = new ArrayList<String>();
        if (goals != null) {
            String[] tokens = StringUtils.split((String)goals, (String)", \n\r\t");
            for (int i = 0; i < tokens.length; ++i) {
                goalsList.add(tokens[i]);
            }
        }
        this.executeGoals(workingDirectory, goalsList, releaseEnvironment, interactive, additionalArguments, pomFileName, result);
    }

    protected abstract void executeGoals(File var1, List<String> var2, ReleaseEnvironment var3, boolean var4, String var5, String var6, ReleaseResult var7) throws MavenExecutorException;

    protected final Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

