/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.env;

import java.io.File;
import java.util.Locale;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.env.ReleaseEnvironment;

public class DefaultReleaseEnvironment
implements ReleaseEnvironment {
    private File mavenHome;
    private File javaHome;
    private File localRepositoryDirectory;
    private Settings settings;
    private String mavenExecutorId = "forked-path";
    private Locale locale = Locale.ENGLISH;

    @Override
    public File getMavenHome() {
        return this.mavenHome;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public ReleaseEnvironment setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
        return this;
    }

    @Override
    public ReleaseEnvironment setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public String getMavenExecutorId() {
        return this.mavenExecutorId;
    }

    @Override
    public ReleaseEnvironment setMavenExecutorId(String mavenExecutorId) {
        this.mavenExecutorId = mavenExecutorId;
        return this;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    @Override
    public ReleaseEnvironment setJavaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    @Override
    public File getLocalRepositoryDirectory() {
        File localRepo = this.localRepositoryDirectory;
        if (localRepo == null && this.settings != null && this.settings.getLocalRepository() != null) {
            localRepo = new File(this.settings.getLocalRepository()).getAbsoluteFile();
        }
        return localRepo;
    }

    @Override
    public ReleaseEnvironment setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
        return this;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public ReleaseEnvironment setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }
}

