/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.checkout;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.apache.maven.scm.provider.bazaar.command.checkout.BazaarCheckOutConsumer;
import org.apache.maven.scm.provider.bazaar.repository.BazaarScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class BazaarCheckOutCommand
extends AbstractCheckOutCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        BazaarScmProviderRepository repository = (BazaarScmProviderRepository)repo;
        String url = repository.getURI();
        File checkoutDir = fileSet.getBasedir();
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Removing " + checkoutDir);
            }
            FileUtils.deleteDirectory((File)checkoutDir);
        }
        catch (IOException e) {
            throw new ScmException("Cannot remove " + checkoutDir);
        }
        ArrayList<String> checkoutCmd = new ArrayList<String>();
        checkoutCmd.add("branch");
        checkoutCmd.add(url);
        checkoutCmd.add(checkoutDir.getAbsolutePath());
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            checkoutCmd.add("--revision");
            checkoutCmd.add("tag:" + version.getName());
        }
        BazaarConsumer checkoutConsumer = new BazaarConsumer(this.getLogger());
        BazaarUtils.execute(checkoutConsumer, this.getLogger(), checkoutDir.getParentFile(), checkoutCmd.toArray(new String[0]));
        String[] inventoryCmd = new String[]{"inventory"};
        BazaarCheckOutConsumer consumer = new BazaarCheckOutConsumer(this.getLogger(), checkoutDir);
        ScmResult result = BazaarUtils.execute(consumer, this.getLogger(), checkoutDir, inventoryCmd);
        if (!result.isSuccess()) {
            throw new ScmException(result.getProviderMessage());
        }
        return new CheckOutScmResult(consumer.getCheckedOutFiles(), result);
    }
}

