/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.list;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;

public class JGitListCommand
extends AbstractListCommand
implements GitCommand {
    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion scmVersion) throws ScmException {
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            CredentialsProvider credentials = JGitUtils.prepareSession(this.getLogger(), git, (GitScmProviderRepository)repo);
            ArrayList<ScmFile> list = new ArrayList<ScmFile>();
            Collection lsResult = ((LsRemoteCommand)((LsRemoteCommand)git.lsRemote().setCredentialsProvider(credentials)).setTransportConfigCallback((TransportConfigCallback)new JGitTransportConfigCallback((GitScmProviderRepository)repo, this.getLogger()))).call();
            for (Ref ref : lsResult) {
                this.getLogger().debug(ref.getObjectId().getName() + "  " + ref.getTarget().getName());
                list.add(new ScmFile(ref.getName(), ScmFileStatus.CHECKED_IN));
            }
            ListScmResult listScmResult = new ListScmResult("JGit ls-remote", list);
            return listScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit ls-remote failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

