/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.blame;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnBlameConsumer
extends AbstractConsumer {
    private static final String SVN_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Pattern LINE_PATTERN = Pattern.compile("line-number=\"(.*)\"");
    private static final Pattern REVISION_PATTERN = Pattern.compile("revision=\"(.*)\"");
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("<author>(.*)</author>");
    private static final Pattern DATE_PATTERN = Pattern.compile("<date>(.*)T(.*)\\.(.*)Z</date>");
    private SimpleDateFormat dateFormat;
    private List<BlameLine> lines = new ArrayList<BlameLine>();
    private int lineNumber;
    private String revision;
    private String author;

    public SvnBlameConsumer(ScmLogger logger) {
        super(logger);
        this.dateFormat = new SimpleDateFormat(SVN_TIMESTAMP_PATTERN);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void consumeLine(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            String lineNumberStr = matcher.group(1);
            this.lineNumber = Integer.parseInt(lineNumberStr);
        } else {
            matcher = REVISION_PATTERN.matcher(line);
            if (matcher.find()) {
                this.revision = matcher.group(1);
            } else {
                matcher = AUTHOR_PATTERN.matcher(line);
                if (matcher.find()) {
                    this.author = matcher.group(1);
                } else {
                    matcher = DATE_PATTERN.matcher(line);
                    if (matcher.find()) {
                        String date = matcher.group(1);
                        String time = matcher.group(2);
                        Date dateTime = this.parseDateTime(date + " " + time);
                        this.lines.add(new BlameLine(dateTime, this.revision, this.author));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Author of line " + this.lineNumber + ": " + this.author + " (" + date + ")");
                        }
                    }
                }
            }
        }
    }

    protected Date parseDateTime(String dateTimeStr) {
        try {
            return this.dateFormat.parse(dateTimeStr);
        }
        catch (ParseException e) {
            this.getLogger().error("skip ParseException: " + e.getMessage() + " during parsing date " + dateTimeStr, (Throwable)e);
            return null;
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

