/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands.edit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.vss.commands.VssCommandLineUtils;
import org.apache.maven.scm.provider.vss.commands.changelog.VssHistoryCommand;
import org.apache.maven.scm.provider.vss.commands.edit.VssEditConsumer;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VssEditCommand
extends AbstractEditCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing checkout command...");
        }
        VssScmProviderRepository repo = (VssScmProviderRepository)repository;
        List<Commandline> commandLines = this.buildCmdLine(repo, fileSet);
        VssEditConsumer consumer = new VssEditConsumer(repo, this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        StringBuilder sb = new StringBuilder();
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        for (Commandline cl : commandLines) {
            int exitCode;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            }
            if ((exitCode = VssCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger())) != 0) {
                String error = stderr.getOutput();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("VSS returns error: [" + error + "] return code: [" + exitCode + "]");
                }
                if (error.indexOf("A writable copy of") < 0) {
                    return new EditScmResult(cl.toString(), "The vss command failed.", error, false);
                }
                if (!this.getLogger().isWarnEnabled()) break;
                this.getLogger().warn(error);
                break;
            }
            sb.append(cl.toString() + '\n');
            updatedFiles.addAll(consumer.getUpdatedFiles());
        }
        return new EditScmResult(sb.toString(), updatedFiles);
    }

    public List<Commandline> buildCmdLine(VssScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        List files = fileSet.getFileList();
        ArrayList<Commandline> commands = new ArrayList<Commandline>();
        if (files.size() > 0) {
            String base;
            try {
                base = fileSet.getBasedir().getCanonicalPath();
            }
            catch (IOException e) {
                throw new ScmException("Invalid canonical path", (Throwable)e);
            }
            for (File file : files) {
                Commandline command = new Commandline();
                try {
                    command.addSystemEnvironment();
                }
                catch (Exception e) {
                    throw new ScmException("Can't add system environment.", (Throwable)e);
                }
                command.addEnvironment("SSDIR", repo.getVssdir());
                String ssDir = VssCommandLineUtils.getSsDir();
                command.setExecutable(ssDir + "ss");
                command.createArg().setValue("Checkout");
                try {
                    String absolute = file.getCanonicalPath();
                    int index = absolute.indexOf(base);
                    String relative = index >= 0 ? absolute.substring(index + base.length()) : file.getPath();
                    relative = relative.replace('\\', '/');
                    if (!relative.startsWith("/")) {
                        relative = '/' + relative;
                    }
                    String relativeFolder = relative.substring(0, relative.lastIndexOf(47));
                    command.setWorkingDirectory(new File(fileSet.getBasedir().getAbsolutePath() + File.separatorChar + relativeFolder).getCanonicalPath());
                    command.createArg().setValue("$" + repo.getProject() + relative);
                }
                catch (IOException e) {
                    throw new ScmException("Invalid canonical path", (Throwable)e);
                }
                if (repo.getUserPassword() != null) {
                    command.createArg().setValue("-Y" + repo.getUserPassword());
                }
                command.createArg().setValue("-I-");
                commands.add(command);
            }
        } else {
            Commandline command = new Commandline();
            command.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
            try {
                command.addSystemEnvironment();
            }
            catch (Exception e) {
                throw new ScmException("Can't add system environment.", (Throwable)e);
            }
            command.addEnvironment("SSDIR", repo.getVssdir());
            String ssDir = VssCommandLineUtils.getSsDir();
            command.setExecutable(ssDir + "ss");
            command.createArg().setValue("Checkout");
            command.createArg().setValue("$" + repo.getProject());
            command.createArg().setValue("-R");
            if (repo.getUserPassword() != null) {
                command.createArg().setValue("-Y" + repo.getUserPassword());
            }
            command.createArg().setValue("-I-");
            commands.add(command);
        }
        return commands;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        VssHistoryCommand command = new VssHistoryCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

