/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=DependencyCollectorBuilder.class)
public class DefaultDependencyCollectorBuilder
extends AbstractLogEnabled
implements DependencyCollectorBuilder,
Contextualizable {
    protected PlexusContainer container;

    @Override
    public DependencyNode collectDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter) throws DependencyCollectorBuilderException {
        try {
            String hint = DefaultDependencyCollectorBuilder.isMaven31() ? "maven31" : "maven3";
            DependencyCollectorBuilder effectiveGraphBuilder = (DependencyCollectorBuilder)this.container.lookup(DependencyCollectorBuilder.class.getCanonicalName(), hint);
            if (this.getLogger().isDebugEnabled()) {
                MavenProject project = buildingRequest.getProject();
                this.getLogger().debug("building " + hint + " RAW dependency tree for " + project.getId() + " with " + effectiveGraphBuilder.getClass().getSimpleName());
            }
            return effectiveGraphBuilder.collectDependencyGraph(buildingRequest, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectorBuilderException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven31() {
        try {
            Class<?> repoSessionClass = MavenSession.class.getMethod("getRepositorySession", new Class[0]).getReturnType();
            return "org.eclipse.aether.RepositorySystemSession".equals(repoSessionClass.getName());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot determine return type of MavenSession.getRepositorySession");
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

