/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.internal.ExceptionHandler;

final class Invoker {
    private Invoker() {
    }

    static <T extends Exception> Object invoke(Object object, String method, ExceptionHandler<T> exceptionHandler) throws T {
        return Invoker.invoke(object.getClass(), object, method, exceptionHandler);
    }

    static <T extends Exception> Object invoke(Class<?> objectClazz, Object object, String method, ExceptionHandler<T> exceptionHandler) throws T {
        try {
            return objectClazz.getMethod(method, new Class[0]).invoke(object, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw exceptionHandler.create(e.getMessage(), e);
        }
    }

    static Object invoke(Object object, String method, Class<?> clazz, Object arg) throws DependencyGraphBuilderException {
        try {
            Class<?> objectClazz = object.getClass();
            return objectClazz.getMethod(method, clazz).invoke(object, arg);
        }
        catch (ReflectiveOperationException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    static <T extends Exception> Object invoke(Class<?> objectClazz, String staticMethod, Class<?> argClazz, Object arg, ExceptionHandler<T> exceptionHandler) throws T {
        try {
            return objectClazz.getMethod(staticMethod, argClazz).invoke(null, arg);
        }
        catch (ReflectiveOperationException e) {
            throw exceptionHandler.create(e.getMessage(), e);
        }
    }

    static <T extends Exception> Object invoke(Class<?> objectClazz, String staticMethod, Class<?> argClazz1, Class<?> argClazz2, Object arg1, Object arg2, ExceptionHandler<T> exceptionHandler) throws T {
        try {
            return objectClazz.getMethod(staticMethod, argClazz1, argClazz2).invoke(null, arg1, arg2);
        }
        catch (ReflectiveOperationException e) {
            throw exceptionHandler.create(e.getMessage(), e);
        }
    }
}

