/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal.maven30;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.maven.shared.dependency.graph.internal.maven30.ConflictResolver;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.collection.UnsolvableVersionConflictException;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.util.graph.PathRecordingDependencyVisitor;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

public final class NearestVersionSelector
extends ConflictResolver.VersionSelector {
    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        ConflictGroup group = new ConflictGroup();
        for (ConflictResolver.ConflictItem item : context.getItems()) {
            boolean hardConstraint;
            DependencyNode node = item.getNode();
            VersionConstraint constraint = node.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = !constraint.getRanges().isEmpty();
            if (hardConstraint && group.constraints.add(constraint) && group.winner != null && !constraint.containsVersion(group.winner.getNode().getVersion())) {
                backtrack = true;
            }
            if (this.isAcceptable(group, node.getVersion())) {
                group.candidates.add(item);
                if (backtrack) {
                    this.backtrack(group, context);
                    continue;
                }
                if (group.winner != null && !this.isNearer(item, group.winner)) continue;
                group.winner = item;
                continue;
            }
            if (!backtrack) continue;
            this.backtrack(group, context);
        }
        context.setWinner(group.winner);
    }

    private void backtrack(ConflictGroup group, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
        group.winner = null;
        Iterator<ConflictResolver.ConflictItem> it = group.candidates.iterator();
        while (it.hasNext()) {
            ConflictResolver.ConflictItem candidate = it.next();
            if (!this.isAcceptable(group, candidate.getNode().getVersion())) {
                it.remove();
                continue;
            }
            if (group.winner != null && !this.isNearer(candidate, group.winner)) continue;
            group.winner = candidate;
        }
        if (group.winner == null) {
            throw this.newFailure(context);
        }
    }

    private boolean isAcceptable(ConflictGroup group, Version version) {
        for (VersionConstraint constraint : group.constraints) {
            if (constraint.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearer(ConflictResolver.ConflictItem item1, ConflictResolver.ConflictItem item2) {
        if (item1.isSibling(item2)) {
            return item1.getNode().getVersion().compareTo((Object)item2.getNode().getVersion()) > 0;
        }
        return item1.getDepth() < item2.getDepth();
    }

    private UnsolvableVersionConflictException newFailure(ConflictResolver.ConflictContext context) {
        DependencyFilter filter = (node, parents) -> context.isIncluded(node);
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(filter);
        context.getRoot().accept((DependencyVisitor)visitor);
        return new UnsolvableVersionConflictException((Collection)visitor.getPaths(), context.conflictId);
    }

    static final class ConflictGroup {
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Collection<ConflictResolver.ConflictItem> candidates = new ArrayList<ConflictResolver.ConflictItem>(64);
        ConflictResolver.ConflictItem winner;

        ConflictGroup() {
        }

        public String toString() {
            return String.valueOf(this.winner);
        }
    }
}

