/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyCollectorRequest;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.ConflictData;
import org.apache.maven.shared.dependency.graph.internal.VerboseDependencyNode;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.VersionConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultDependencyCollectorBuilder
implements DependencyCollectorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependencyCollectorBuilder.class);
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultDependencyCollectorBuilder(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    @Override
    public DependencyNode collectDependencyGraph(DependencyCollectorRequest dependencyCollectorRequest) throws DependencyCollectorBuilderException {
        DefaultRepositorySystemSession session = null;
        try {
            ProjectBuildingRequest buildingRequest = dependencyCollectorRequest.getBuildingRequest();
            MavenProject project = buildingRequest.getProject();
            org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
            List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
            RepositorySystemSession repositorySession = buildingRequest.getRepositorySession();
            session = new DefaultRepositorySystemSession(repositorySession);
            session.setDependencyGraphTransformer(dependencyCollectorRequest.getDependencyGraphTransformer());
            session.setDependencySelector(dependencyCollectorRequest.getDependencySelector());
            for (Map.Entry<String, Object> entry : dependencyCollectorRequest.getConfigProperties().entrySet()) {
                session.setConfigProperty(entry.getKey(), entry.getValue());
            }
            Artifact aetherArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)projectArtifact);
            List aetherRepos = RepositoryUtils.toRepos((List)remoteArtifactRepositories);
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRootArtifact(aetherArtifact);
            collectRequest.setRepositories(aetherRepos);
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            this.collectDependencyList(collectRequest, project, stereotypes);
            this.collectManagedDependencyList(collectRequest, project, stereotypes);
            CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            org.eclipse.aether.graph.DependencyNode rootNode = collectResult.getRoot();
            if (LOGGER.isDebugEnabled()) {
                this.logTree(rootNode);
            }
            DependencyNode dependencyNode = this.buildDependencyNode(null, rootNode, projectArtifact, dependencyCollectorRequest.getFilter());
            return dependencyNode;
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorBuilderException("Could not collect dependencies: " + e.getResult(), e);
        }
        finally {
            if (session != null) {
                session.setReadOnly();
            }
        }
    }

    private void logTree(org.eclipse.aether.graph.DependencyNode rootNode) {
        rootNode.accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){
            String indent = "";

            public boolean visitEnter(org.eclipse.aether.graph.DependencyNode dependencyNode) {
                LOGGER.debug("{}Aether node: {} data map: {}", new Object[]{this.indent, dependencyNode, dependencyNode.getData()});
                this.indent = this.indent + "    ";
                return true;
            }

            public boolean visitLeave(org.eclipse.aether.graph.DependencyNode dependencyNode) {
                this.indent = this.indent.substring(0, this.indent.length() - 4);
                return true;
            }
        }));
    }

    private void collectManagedDependencyList(CollectRequest collectRequest, MavenProject project, ArtifactTypeRegistry stereotypes) {
        if (project.getDependencyManagement() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                org.eclipse.aether.graph.Dependency aetherDep = RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes);
                collectRequest.addManagedDependency(aetherDep);
            }
        }
    }

    private void collectDependencyList(CollectRequest collectRequest, MavenProject project, ArtifactTypeRegistry stereotypes) {
        for (Dependency dependency : project.getDependencies()) {
            org.eclipse.aether.graph.Dependency aetherDep = RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes);
            collectRequest.addDependency(aetherDep);
        }
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(org.eclipse.aether.graph.Dependency dep) {
        Artifact artifact = dep.getArtifact();
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        mavenArtifact.setScope(dep.getScope());
        mavenArtifact.setOptional(dep.isOptional());
        return mavenArtifact;
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.eclipse.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((org.eclipse.aether.graph.DependencyNode)node);
        String premanagedScope = DependencyManagerUtils.getPremanagedScope((org.eclipse.aether.graph.DependencyNode)node);
        Boolean optional = null;
        if (node.getDependency() != null) {
            optional = node.getDependency().isOptional();
        }
        ArrayList<Exclusion> exclusions = null;
        if (node.getDependency() != null) {
            exclusions = new ArrayList<Exclusion>(node.getDependency().getExclusions().size());
            for (org.eclipse.aether.graph.Exclusion exclusion : node.getDependency().getExclusions()) {
                Exclusion modelExclusion = new Exclusion();
                modelExclusion.setGroupId(exclusion.getGroupId());
                modelExclusion.setArtifactId(exclusion.getArtifactId());
                exclusions.add(modelExclusion);
            }
        }
        org.eclipse.aether.graph.DependencyNode winner = (org.eclipse.aether.graph.DependencyNode)node.getData().get("conflict.winner");
        String winnerVersion = null;
        String ignoredScope = null;
        if (winner != null) {
            winnerVersion = winner.getArtifact().getBaseVersion();
        } else {
            ignoredScope = (String)node.getData().get("REDUCED_SCOPE");
        }
        ConflictData data = new ConflictData(winnerVersion, ignoredScope);
        VerboseDependencyNode current = new VerboseDependencyNode(parent, artifact, premanagedVersion, premanagedScope, this.getVersionSelectedFromRange(node.getVersionConstraint()), optional, exclusions, data);
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.eclipse.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        return constraint.getRange().toString();
    }
}

