/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.util.internal.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireProperties
extends Properties
implements KeyValueSource {
    private final LinkedHashSet<Object> items = new LinkedHashSet();
    private static final Set<String> keysThatCannotBeUsedAsSystemProperties = new HashSet<String>(){
        {
            this.add("java.library.path");
            this.add("file.encoding");
            this.add("jdk.map.althashing.threshold");
        }
    };

    public SurefireProperties() {
    }

    public SurefireProperties(Properties source) {
        if (source != null) {
            this.putAll((Map<?, ?>)source);
        }
    }

    public SurefireProperties(KeyValueSource source) {
        if (source != null) {
            source.copyTo((Map)this);
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.items.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.items.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.items);
    }

    public void copyPropertiesFrom(Properties source) {
        if (source != null) {
            for (Object key : source.keySet()) {
                Object value = source.get(key);
                this.put(key, value);
            }
        }
    }

    public Iterable<Object> getStringKeySet() {
        return this.keySet();
    }

    public Set<Object> propertiesThatCannotBeSetASystemProperties() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object key : this.getStringKeySet()) {
            if (!keysThatCannotBeUsedAsSystemProperties.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public void copyToSystemProperties() {
        for (Object e : this.items) {
            String key = (String)e;
            String value = this.getProperty(key);
            System.setProperty(key, value);
        }
    }

    static SurefireProperties calculateEffectiveProperties(Properties systemProperties, Map<String, String> systemPropertyVariables, Properties userProperties, SurefireProperties props) {
        SurefireProperties result = new SurefireProperties();
        result.copyPropertiesFrom(systemProperties);
        result.copyPropertiesFrom(props);
        SurefireProperties.copyProperties(result, systemPropertyVariables);
        SurefireProperties.copyProperties(result, systemPropertyVariables);
        result.copyPropertiesFrom(userProperties);
        return result;
    }

    public static void copyProperties(Properties target, Map<String, String> source) {
        if (source != null) {
            for (String key : source.keySet()) {
                String value = source.get(key);
                if (value == null) continue;
                target.setProperty(key, value);
            }
        }
    }

    public void copyTo(Map target) {
        for (Object key : this.keySet()) {
            target.put(key, this.get(key));
        }
    }

    public void setProperty(String key, File file) {
        if (file != null) {
            this.setProperty(key, file.toString());
        }
    }

    public void setProperty(String key, Boolean aBoolean) {
        if (aBoolean != null) {
            this.setProperty(key, aBoolean.toString());
        }
    }

    public void addList(List items, String propertyPrefix) {
        if (items == null || items.size() == 0) {
            return;
        }
        int i = 0;
        for (Object item : items) {
            String[] stringArray;
            if (item == null) {
                throw new NullPointerException(propertyPrefix + i + " has null value");
            }
            for (String aStringArray : stringArray = StringUtils.split((String)item.toString(), (String)",")) {
                this.setProperty(propertyPrefix + i, aStringArray);
                ++i;
            }
        }
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List classpathElements = classpath.getClassPath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = (String)classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SurefireProperties loadProperties(InputStream inStream) throws IOException {
        Properties p = new Properties();
        try {
            p.load(inStream);
        }
        finally {
            SurefireProperties.close(inStream);
        }
        return new SurefireProperties(p);
    }

    public static SurefireProperties loadProperties(File file) throws IOException {
        if (file != null) {
            return SurefireProperties.loadProperties(new FileInputStream(file));
        }
        return new SurefireProperties();
    }

    private static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNullableProperty(String key, String value) {
        if (value != null) {
            super.setProperty(key, value);
        }
    }
}

