/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestMethodStats;
import org.apache.maven.plugin.surefire.report.TestSetRunListener;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.report.DefaultDirectConsoleReporter;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReporterFactory
implements ReporterFactory {
    private RunStatistics globalStats = new RunStatistics();
    private final StartupReportConfiguration reportConfiguration;
    private final StatisticsReporter statisticsReporter;
    private final List<TestSetRunListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<String, List<TestMethodStats>> flakyTests = null;
    private Map<String, List<TestMethodStats>> failedTests = null;
    private Map<String, List<TestMethodStats>> errorTests = null;

    public DefaultReporterFactory(StartupReportConfiguration reportConfiguration) {
        this.reportConfiguration = reportConfiguration;
        this.statisticsReporter = reportConfiguration.instantiateStatisticsReporter();
    }

    public RunListener createReporter() {
        return this.createTestSetRunListener();
    }

    public void mergeFromOtherFactories(List<DefaultReporterFactory> factories) {
        for (DefaultReporterFactory factory : factories) {
            for (TestSetRunListener listener : factory.listeners) {
                this.listeners.add(listener);
            }
        }
    }

    public RunListener createTestSetRunListener() {
        TestSetRunListener testSetRunListener = new TestSetRunListener(this.reportConfiguration.instantiateConsoleReporter(), this.reportConfiguration.instantiateFileReporter(), this.reportConfiguration.instantiateStatelessXmlReporter(), this.reportConfiguration.instantiateConsoleOutputFileReporter(), this.statisticsReporter, this.reportConfiguration.isTrimStackTrace(), "plain".equals(this.reportConfiguration.getReportFormat()), this.reportConfiguration.isBriefOrPlainFormat());
        this.listeners.add(testSetRunListener);
        return testSetRunListener;
    }

    public void addListener(TestSetRunListener listener) {
        this.listeners.add(listener);
    }

    public RunResult close() {
        this.mergeTestHistoryResult();
        this.runCompleted();
        for (TestSetRunListener listener : this.listeners) {
            listener.close();
        }
        return this.globalStats.getRunResult();
    }

    private DefaultDirectConsoleReporter createConsoleLogger() {
        return new DefaultDirectConsoleReporter(this.reportConfiguration.getOriginalSystemOut());
    }

    public void runStarting() {
        DefaultDirectConsoleReporter consoleReporter = this.createConsoleLogger();
        consoleReporter.info("");
        consoleReporter.info("-------------------------------------------------------");
        consoleReporter.info(" T E S T S");
        consoleReporter.info("-------------------------------------------------------");
    }

    private void runCompleted() {
        DefaultDirectConsoleReporter logger = this.createConsoleLogger();
        if (this.reportConfiguration.isPrintSummary()) {
            logger.info("");
            logger.info("Results :");
            logger.info("");
        }
        this.printTestFailures(logger, TestResultType.failure);
        this.printTestFailures(logger, TestResultType.error);
        this.printTestFailures(logger, TestResultType.flake);
        logger.info(this.globalStats.getSummary());
        logger.info("");
    }

    public RunStatistics getGlobalRunStatistics() {
        this.mergeTestHistoryResult();
        return this.globalStats;
    }

    public static DefaultReporterFactory defaultNoXml() {
        return new DefaultReporterFactory(StartupReportConfiguration.defaultNoXml());
    }

    static TestResultType getTestResultType(List<ReportEntryType> reportEntryList, int rerunFailingTestsCount) {
        if (reportEntryList == null || reportEntryList.size() == 0) {
            return TestResultType.unknown;
        }
        boolean seenSuccess = false;
        boolean seenFailure = false;
        boolean seenError = false;
        for (ReportEntryType resultType : reportEntryList) {
            if (resultType == ReportEntryType.SUCCESS) {
                seenSuccess = true;
                continue;
            }
            if (resultType == ReportEntryType.FAILURE) {
                seenFailure = true;
                continue;
            }
            if (resultType != ReportEntryType.ERROR) continue;
            seenError = true;
        }
        if (seenFailure || seenError) {
            if (seenSuccess && rerunFailingTestsCount > 0) {
                return TestResultType.flake;
            }
            if (seenError) {
                return TestResultType.error;
            }
            if (seenFailure) {
                return TestResultType.failure;
            }
            return TestResultType.skipped;
        }
        if (seenSuccess) {
            return TestResultType.success;
        }
        return TestResultType.skipped;
    }

    void mergeTestHistoryResult() {
        this.globalStats = new RunStatistics();
        this.flakyTests = new TreeMap<String, List<TestMethodStats>>();
        this.failedTests = new TreeMap<String, List<TestMethodStats>>();
        this.errorTests = new TreeMap<String, List<TestMethodStats>>();
        HashMap<String, ArrayList<TestMethodStats>> mergedTestHistoryResult = new HashMap<String, ArrayList<TestMethodStats>>();
        for (TestSetRunListener listener : this.listeners) {
            List<TestMethodStats> testMethodStats = listener.getTestMethodStats();
            for (TestMethodStats methodStats : testMethodStats) {
                ArrayList<TestMethodStats> currentMethodStats = (ArrayList<TestMethodStats>)mergedTestHistoryResult.get(methodStats.getTestClassMethodName());
                if (currentMethodStats == null) {
                    currentMethodStats = new ArrayList<TestMethodStats>();
                    currentMethodStats.add(methodStats);
                    mergedTestHistoryResult.put(methodStats.getTestClassMethodName(), currentMethodStats);
                    continue;
                }
                currentMethodStats.add(methodStats);
            }
        }
        int completedCount = 0;
        int skipped = 0;
        block9: for (Map.Entry entry : mergedTestHistoryResult.entrySet()) {
            List testMethodStats = (List)entry.getValue();
            String testClassMethodName = (String)entry.getKey();
            ++completedCount;
            ArrayList<ReportEntryType> resultTypeList = new ArrayList<ReportEntryType>();
            for (TestMethodStats methodStats : testMethodStats) {
                resultTypeList.add(methodStats.getResultType());
            }
            TestResultType resultType = DefaultReporterFactory.getTestResultType(resultTypeList, this.reportConfiguration.getRerunFailingTestsCount());
            switch (resultType) {
                case success: {
                    int successCount = 0;
                    for (ReportEntryType type : resultTypeList) {
                        if (type != ReportEntryType.SUCCESS) continue;
                        ++successCount;
                    }
                    completedCount += successCount - 1;
                    continue block9;
                }
                case skipped: {
                    ++skipped;
                    continue block9;
                }
                case flake: {
                    this.flakyTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case failure: {
                    this.failedTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case error: {
                    this.errorTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
            }
            throw new IllegalStateException("Get unknown test result type");
        }
        this.globalStats.set(completedCount, this.errorTests.size(), this.failedTests.size(), skipped, this.flakyTests.size());
    }

    void printTestFailures(DefaultDirectConsoleReporter logger, TestResultType type) {
        Map<String, List<TestMethodStats>> testStats;
        if (type == TestResultType.failure) {
            testStats = this.failedTests;
        } else if (type == TestResultType.error) {
            testStats = this.errorTests;
        } else if (type == TestResultType.flake) {
            testStats = this.flakyTests;
        } else {
            logger.info("");
            return;
        }
        if (testStats.size() > 0) {
            logger.info(type.getLogPrefix());
        }
        for (Map.Entry<String, List<TestMethodStats>> entry : testStats.entrySet()) {
            List<TestMethodStats> testMethodStats = entry.getValue();
            if (testMethodStats.size() == 1) {
                logger.info("  " + testMethodStats.get(0).getStackTraceWriter().smartTrimmedStackTrace());
                continue;
            }
            logger.info(entry.getKey());
            for (int i = 0; i < testMethodStats.size(); ++i) {
                StackTraceWriter failureStackTrace = testMethodStats.get(i).getStackTraceWriter();
                if (failureStackTrace == null) {
                    logger.info("  Run " + (i + 1) + ": PASS");
                    continue;
                }
                logger.info("  Run " + (i + 1) + ": " + failureStackTrace.smartTrimmedStackTrace());
            }
            logger.info("");
        }
        logger.info("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TestResultType {
        error("Tests in error: "),
        failure("Failed tests: "),
        flake("Flaked tests: "),
        success("Success: "),
        skipped("Skipped: "),
        unknown("Unknown: ");

        private final String logPrefix;

        private TestResultType(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

