/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.booter.Constants;
import org.apache.maven.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.surefire.api.stream.AbstractStreamEncoder;

public class CommandEncoder
extends AbstractStreamEncoder<MasterProcessCommand>
implements AutoCloseable {
    private final WritableByteChannel out;

    public CommandEncoder(WritableByteChannel out) {
        super(out);
        this.out = out;
    }

    public void sendRunClass(String testClassName) throws IOException {
        CharsetEncoder encoder = this.newCharsetEncoder();
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.RUN_CLASS.getOpcodeLength(), null, encoder, 0, 0, new String[]{testClassName});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encode(encoder, result, (Enum)MasterProcessCommand.RUN_CLASS, new String[]{testClassName});
        this.write(result, true);
    }

    public void sendTestSetFinished() throws IOException {
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.TEST_SET_FINISHED.getOpcodeLength(), null, null, 0, 0, new String[0]);
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)MasterProcessCommand.TEST_SET_FINISHED);
        this.write(result, true);
    }

    public void sendSkipSinceNextTest() throws IOException {
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.SKIP_SINCE_NEXT_TEST.getOpcodeLength(), null, null, 0, 0, new String[0]);
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)MasterProcessCommand.SKIP_SINCE_NEXT_TEST);
        this.write(result, true);
    }

    public void sendShutdown(String shutdownData) throws IOException {
        CharsetEncoder encoder = this.newCharsetEncoder();
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.SHUTDOWN.getOpcodeLength(), null, encoder, 0, 0, new String[]{shutdownData});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encode(encoder, result, (Enum)MasterProcessCommand.SHUTDOWN, new String[]{shutdownData});
        this.write(result, true);
    }

    public void sendNoop() throws IOException {
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.NOOP.getOpcodeLength(), null, null, 0, 0, new String[0]);
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)MasterProcessCommand.NOOP);
        this.write(result, true);
    }

    public void sendByeAck() throws IOException {
        int bufferMaxLength = this.estimateBufferLength(MasterProcessCommand.BYE_ACK.getOpcodeLength(), null, null, 0, 0, new String[0]);
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)MasterProcessCommand.BYE_ACK);
        this.write(result, true);
    }

    @Nonnull
    protected final byte[] getEncodedMagicNumber() {
        return Constants.MAGIC_NUMBER_FOR_COMMANDS_BYTES;
    }

    @Nonnull
    protected final byte[] enumToByteArray(MasterProcessCommand masterProcessCommand) {
        return masterProcessCommand.getOpcodeBinary();
    }

    @Nonnull
    protected final byte[] getEncodedCharsetName() {
        return Constants.DEFAULT_STREAM_ENCODING_BYTES;
    }

    @Nonnull
    protected final Charset getCharset() {
        return Constants.DEFAULT_STREAM_ENCODING;
    }

    @Nonnull
    protected final CharsetEncoder newCharsetEncoder() {
        return this.getCharset().newEncoder();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

