/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.booter;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;

public enum MasterProcessCommand {
    RUN_CLASS("run-testclass", String.class),
    TEST_SET_FINISHED("testset-finished", Void.class),
    SKIP_SINCE_NEXT_TEST("skip-since-next-test", Void.class),
    SHUTDOWN("shutdown", String.class),
    NOOP("noop", Void.class),
    BYE_ACK("bye-ack", Void.class);

    public static final Map<AbstractStreamDecoder.Segment, MasterProcessCommand> COMMAND_TYPES;
    private final String opcode;
    private final byte[] opcodeBinary;
    private final Class<?> dataType;

    private MasterProcessCommand(String opcode, Class<?> dataType) {
        this.opcode = Objects.requireNonNull(opcode, "value cannot be null");
        this.opcodeBinary = opcode.getBytes(StandardCharsets.US_ASCII);
        this.dataType = Objects.requireNonNull(dataType, "dataType cannot be null");
    }

    public byte[] getOpcodeBinary() {
        return this.opcodeBinary;
    }

    public int getOpcodeLength() {
        return this.opcodeBinary.length;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasDataType() {
        return this.dataType != Void.class;
    }

    public String toString() {
        return this.opcode;
    }

    private static Map<AbstractStreamDecoder.Segment, MasterProcessCommand> segmentsToCmds() {
        HashMap<AbstractStreamDecoder.Segment, MasterProcessCommand> commands = new HashMap<AbstractStreamDecoder.Segment, MasterProcessCommand>();
        for (MasterProcessCommand command : MasterProcessCommand.values()) {
            byte[] array = command.toString().getBytes(StandardCharsets.US_ASCII);
            commands.put(new AbstractStreamDecoder.Segment(array, 0, array.length), command);
        }
        return commands;
    }

    static {
        COMMAND_TYPES = MasterProcessCommand.segmentsToCmds();
    }
}

