/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.util.internal.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesWrapper
implements KeyValueSource {
    private final Properties properties;

    public PropertiesWrapper(Properties properties) {
        if (properties == null) {
            throw new IllegalStateException("Properties cannot be null");
        }
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setAsSystemProperties() {
        for (Object o : this.properties.keySet()) {
            String key = (String)o;
            System.setProperty(key, this.properties.getProperty(key));
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBooleanProperty(String propertyName) {
        return Boolean.valueOf(this.properties.getProperty(propertyName));
    }

    public Boolean getBooleanObjectProperty(String propertyName) {
        return Boolean.valueOf(this.properties.getProperty(propertyName));
    }

    public int getIntProperty(String propertyName) {
        return Integer.parseInt(this.properties.getProperty(propertyName));
    }

    public File getFileProperty(String key) {
        String property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        TypeEncodedValue typeEncodedValue = new TypeEncodedValue(File.class.getName(), property);
        return (File)typeEncodedValue.getDecodedValue();
    }

    public List<String> getStringList(String propertyPrefix) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String value;
        while ((value = this.getProperty(propertyPrefix + i++)) != null) {
            result.add(value);
        }
        return result;
    }

    public TypeEncodedValue getTypeEncodedValue(String key) {
        String typeEncoded = this.getProperty(key);
        if (typeEncoded == null) {
            return null;
        }
        int typeSep = typeEncoded.indexOf("|");
        String type = typeEncoded.substring(0, typeSep);
        String value = typeEncoded.substring(typeSep + 1);
        return new TypeEncodedValue(type, value);
    }

    Classpath getClasspath(String prefix) {
        List<String> elements = this.getStringList(prefix);
        return new Classpath(elements);
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List<String> classpathElements = classpath.getClassPath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        }
    }

    public void addList(List items, String propertyPrefix) {
        if (items == null || items.size() == 0) {
            return;
        }
        int i = 0;
        for (Object item : items) {
            String[] stringArray;
            if (item == null) {
                throw new NullPointerException(propertyPrefix + i + " has null value");
            }
            for (String aStringArray : stringArray = StringUtils.split((String)item.toString(), (String)",")) {
                this.properties.setProperty(propertyPrefix + i, aStringArray);
                ++i;
            }
        }
    }

    @Override
    public void copyTo(Map target) {
        for (Object key : this.properties.keySet()) {
            target.put(key, this.properties.get(key));
        }
    }
}

