/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.booter.DumpErrorSingleton;
import org.apache.maven.surefire.booter.ProcessInfo;
import org.apache.maven.surefire.shade.org.apache.commons.io.IOUtils;
import org.apache.maven.surefire.shade.org.apache.commons.lang3.StringUtils;
import org.apache.maven.surefire.shade.org.apache.commons.lang3.SystemUtils;

final class PpidChecker {
    private static final String WMIC_CREATION_DATE = "CreationDate";
    private static final String WINDOWS_SYSTEM_ROOT_ENV = "SystemRoot";
    private static final String RELATIVE_PATH_TO_WMIC = "System32\\Wbem";
    private static final String SYSTEM_PATH_TO_WMIC = "%SystemRoot%\\System32\\Wbem\\";
    private final Queue<Process> destroyableCommands = new ConcurrentLinkedQueue<Process>();
    static final Pattern UNIX_CMD_OUT_PATTERN = Pattern.compile("^(((\\d+)-)?(\\d{1,2}):)?(\\d{1,2}):(\\d{1,2})$");
    private final long pluginPid;
    private volatile ProcessInfo pluginProcessInfo;
    private volatile boolean stopped;

    PpidChecker(long pluginPid) {
        this.pluginPid = pluginPid;
    }

    boolean canUse() {
        return this.pluginProcessInfo == null ? SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_UNIX && PpidChecker.canExecuteUnixPs() : this.pluginProcessInfo.isValid() && !this.pluginProcessInfo.isError();
    }

    boolean isProcessAlive() {
        if (!this.canUse()) {
            throw new IllegalStateException("irrelevant to call isProcessAlive()");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            ProcessInfo previousPluginProcessInfo = this.pluginProcessInfo;
            this.pluginProcessInfo = this.windows();
            if (this.isStopped() || this.pluginProcessInfo.isError()) {
                throw new IllegalStateException("error to read process");
            }
            return this.pluginProcessInfo.isValid() && (previousPluginProcessInfo == null || this.pluginProcessInfo.isTimeEqualTo(previousPluginProcessInfo));
        }
        if (SystemUtils.IS_OS_UNIX) {
            ProcessInfo previousPluginProcessInfo = this.pluginProcessInfo;
            this.pluginProcessInfo = this.unix();
            if (this.isStopped() || this.pluginProcessInfo.isError()) {
                throw new IllegalStateException("error to read process");
            }
            return this.pluginProcessInfo.isValid() && (previousPluginProcessInfo == null || this.pluginProcessInfo.isTimeEqualTo(previousPluginProcessInfo) || this.pluginProcessInfo.isTimeAfter(previousPluginProcessInfo));
        }
        throw new IllegalStateException();
    }

    ProcessInfo unix() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer(Charset.defaultCharset().name()){

            @Override
            ProcessInfo consumeLine(String line, ProcessInfo previousProcessInfo) {
                Matcher matcher;
                if (!previousProcessInfo.isValid() && (matcher = UNIX_CMD_OUT_PATTERN.matcher(line)).matches()) {
                    long pidUptime = PpidChecker.fromDays(matcher) + PpidChecker.fromHours(matcher) + PpidChecker.fromMinutes(matcher) + PpidChecker.fromSeconds(matcher);
                    return ProcessInfo.unixProcessInfo(PpidChecker.this.pluginPid, pidUptime);
                }
                return previousProcessInfo;
            }
        };
        return reader.execute("/bin/sh", "-c", PpidChecker.unixPathToPS() + " -o etime= -p " + this.pluginPid);
    }

    ProcessInfo windows() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer("US-ASCII"){
            private boolean hasHeader;

            @Override
            ProcessInfo consumeLine(String line, ProcessInfo previousProcessInfo) {
                StringTokenizer args;
                if (!previousProcessInfo.isValid() && (args = new StringTokenizer(line)).countTokens() == 1) {
                    if (this.hasHeader) {
                        String startTimestamp = args.nextToken();
                        return ProcessInfo.windowsProcessInfo(PpidChecker.this.pluginPid, startTimestamp);
                    }
                    this.hasHeader = PpidChecker.WMIC_CREATION_DATE.equals(args.nextToken());
                }
                return previousProcessInfo;
            }
        };
        String pid = String.valueOf(this.pluginPid);
        String wmicPath = PpidChecker.hasWmicStandardSystemPath() ? SYSTEM_PATH_TO_WMIC : "";
        return reader.execute("CMD", "/A", "/X", "/C", wmicPath + "wmic process where (ProcessId=" + pid + ") get " + WMIC_CREATION_DATE);
    }

    void destroyActiveCommands() {
        this.stopped = true;
        Process p = this.destroyableCommands.poll();
        while (p != null) {
            p.destroy();
            p = this.destroyableCommands.poll();
        }
    }

    private boolean isStopped() {
        return this.stopped;
    }

    static String unixPathToPS() {
        return PpidChecker.canExecuteLocalUnixPs() ? "/usr/bin/ps" : "/bin/ps";
    }

    static boolean canExecuteUnixPs() {
        return PpidChecker.canExecuteLocalUnixPs() || PpidChecker.canExecuteStandardUnixPs();
    }

    private static boolean canExecuteLocalUnixPs() {
        return new File("/usr/bin/ps").canExecute();
    }

    private static boolean canExecuteStandardUnixPs() {
        return new File("/bin/ps").canExecute();
    }

    private static boolean hasWmicStandardSystemPath() {
        String systemRoot = System.getenv(WINDOWS_SYSTEM_ROOT_ENV);
        return StringUtils.isNotBlank(systemRoot) && new File(systemRoot, "System32\\Wbem\\wmic.exe").isFile();
    }

    static long fromDays(Matcher matcher) {
        String s = matcher.group(3);
        return s == null ? 0L : TimeUnit.DAYS.toSeconds(Long.parseLong(s));
    }

    static long fromHours(Matcher matcher) {
        String s = matcher.group(4);
        return s == null ? 0L : TimeUnit.HOURS.toSeconds(Long.parseLong(s));
    }

    static long fromMinutes(Matcher matcher) {
        String s = matcher.group(5);
        return s == null ? 0L : TimeUnit.MINUTES.toSeconds(Long.parseLong(s));
    }

    static long fromSeconds(Matcher matcher) {
        String s = matcher.group(6);
        return s == null ? 0L : Long.parseLong(s);
    }

    private static void checkValid(Scanner scanner) throws IOException {
        IOException exception = scanner.ioException();
        if (exception != null) {
            throw exception;
        }
    }

    private abstract class ProcessInfoConsumer {
        private final String charset;

        ProcessInfoConsumer(String charset) {
            this.charset = charset;
        }

        abstract ProcessInfo consumeLine(String var1, ProcessInfo var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProcessInfo execute(String ... command) {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = null;
            ProcessInfo processInfo = ProcessInfo.INVALID_PROCESS_INFO;
            try {
                process = processBuilder.start();
                PpidChecker.this.destroyableCommands.add(process);
                Scanner scanner = new Scanner(process.getInputStream(), this.charset);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    processInfo = this.consumeLine(line, processInfo);
                }
                PpidChecker.checkValid(scanner);
                int exitCode = process.waitFor();
                ProcessInfo processInfo2 = exitCode == 0 ? processInfo : ProcessInfo.INVALID_PROCESS_INFO;
                return processInfo2;
            }
            catch (IOException e) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
                ProcessInfo processInfo3 = ProcessInfo.ERR_PROCESS_INFO;
                return processInfo3;
            }
            catch (InterruptedException e) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
                ProcessInfo processInfo4 = ProcessInfo.ERR_PROCESS_INFO;
                return processInfo4;
            }
            finally {
                if (process != null) {
                    PpidChecker.this.destroyableCommands.remove(process);
                    process.destroy();
                    IOUtils.closeQuietly(process.getInputStream());
                    IOUtils.closeQuietly(process.getErrorStream());
                    IOUtils.closeQuietly(process.getOutputStream());
                }
            }
        }
    }
}

