/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.junitplatform.JUnitPlatformProvider;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.LegacyReportingUtils;

final class RunListenerAdapter
implements TestExecutionListener {
    private final RunListener runListener;
    private TestPlan testPlan;
    private Set<TestIdentifier> testSetNodes = ConcurrentHashMap.newKeySet();

    RunListenerAdapter(RunListener runListener) {
        this.runListener = runListener;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.updateTestPlan(testPlan);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.updateTestPlan(null);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            if (testIdentifier.getSource().filter(ClassSource.class::isInstance).isPresent()) {
                this.startTestSetIfPossible(testIdentifier);
            }
        }
        if (testIdentifier.isTest()) {
            this.ensureTestSetStarted(testIdentifier);
            this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier));
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.ensureTestSetStarted(testIdentifier);
        String source = this.getLegacyReportingClassName(testIdentifier);
        this.runListener.testSkipped((ReportEntry)SimpleReportEntry.ignored((String)source, (String)this.getLegacyReportingName(testIdentifier), (String)reason));
        this.completeTestSetIfNecessary(testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult));
        } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportFailedTest(testIdentifier, testExecutionResult);
        } else if (testIdentifier.isTest()) {
            this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier));
        }
        this.completeTestSetIfNecessary(testIdentifier);
    }

    private void updateTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.testSetNodes.clear();
    }

    private void ensureTestSetStarted(TestIdentifier testIdentifier) {
        if (this.isTestSetStarted(testIdentifier)) {
            return;
        }
        if (testIdentifier.isTest()) {
            this.startTestSet(this.testPlan.getParent(testIdentifier).orElse(testIdentifier));
        } else {
            this.startTestSet(testIdentifier);
        }
    }

    private boolean isTestSetStarted(TestIdentifier testIdentifier) {
        return this.testSetNodes.contains(testIdentifier) || this.testPlan.getParent(testIdentifier).map(this::isTestSetStarted).orElse(false) != false;
    }

    private void startTestSetIfPossible(TestIdentifier testIdentifier) {
        if (!this.isTestSetStarted(testIdentifier)) {
            this.startTestSet(testIdentifier);
        }
    }

    private void completeTestSetIfNecessary(TestIdentifier testIdentifier) {
        if (this.testSetNodes.contains(testIdentifier)) {
            this.completeTestSet(testIdentifier);
        }
    }

    private void startTestSet(TestIdentifier testIdentifier) {
        this.runListener.testSetStarting((TestSetReportEntry)this.createTestSetReportEntry(testIdentifier));
        this.testSetNodes.add(testIdentifier);
    }

    private void completeTestSet(TestIdentifier testIdentifier) {
        this.runListener.testSetCompleted((TestSetReportEntry)this.createTestSetReportEntry(testIdentifier));
        this.testSetNodes.remove(testIdentifier);
    }

    private void reportFailedTest(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        SimpleReportEntry reportEntry = this.createReportEntry(testIdentifier, testExecutionResult);
        if (testExecutionResult.getThrowable().filter(AssertionError.class::isInstance).isPresent()) {
            this.runListener.testFailed((ReportEntry)reportEntry);
        } else {
            this.runListener.testError((ReportEntry)reportEntry);
        }
    }

    private SimpleReportEntry createTestSetReportEntry(TestIdentifier testIdentifier) {
        return new SimpleReportEntry(JUnitPlatformProvider.class.getName(), testIdentifier.getLegacyReportingName());
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier) {
        return this.createReportEntry(testIdentifier, (StackTraceWriter)null);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        return this.createReportEntry(testIdentifier, this.getStackTraceWriter(testIdentifier, testExecutionResult));
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, StackTraceWriter stackTraceWriter) {
        String source = this.getLegacyReportingClassName(testIdentifier);
        String name = this.getLegacyReportingName(testIdentifier);
        return SimpleReportEntry.withException((String)source, (String)name, (StackTraceWriter)stackTraceWriter);
    }

    private String getLegacyReportingName(TestIdentifier testIdentifier) {
        return testIdentifier.getLegacyReportingName().replace("()", "").replace('(', '{').replace(')', '}');
    }

    private String getLegacyReportingClassName(TestIdentifier testIdentifier) {
        return LegacyReportingUtils.getClassName((TestPlan)this.testPlan, (TestIdentifier)testIdentifier);
    }

    private StackTraceWriter getStackTraceWriter(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Optional throwable = testExecutionResult.getThrowable();
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            return this.getStackTraceWriter(testIdentifier, (Throwable)throwable.orElse(null));
        }
        return throwable.map(t -> this.getStackTraceWriter(testIdentifier, (Throwable)t)).orElse(null);
    }

    private StackTraceWriter getStackTraceWriter(TestIdentifier testIdentifier, Throwable throwable) {
        String className = this.getClassName(testIdentifier);
        String methodName = this.getMethodName(testIdentifier).orElse("");
        return new PojoStackTraceWriter(className, methodName, throwable);
    }

    private String getClassName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            return ((ClassSource)testSource).getJavaClass().getName();
        }
        if (testSource instanceof MethodSource) {
            return ((MethodSource)testSource).getClassName();
        }
        return this.testPlan.getParent(testIdentifier).map(this::getClassName).orElse("");
    }

    private Optional<String> getMethodName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof MethodSource) {
            return Optional.of(((MethodSource)testSource).getMethodName());
        }
        return Optional.empty();
    }
}

