/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.plexus.util.FileUtils;

public class WagonUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String resource, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file = null;
        try {
            String retValue;
            file = File.createTempFile("wagon", "tmp");
            wagon.get(resource, file);
            String string = retValue = FileUtils.fileRead((File)file);
            return string;
        }
        finally {
            boolean deleted;
            if (file != null && !(deleted = file.delete())) {
                file.deleteOnExit();
            }
        }
    }

    public static void putDirectory(File dir, Wagon wagon, boolean includeBasdir) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> queue = new LinkedList<String>();
        if (includeBasdir) {
            queue.add(dir.getName());
        } else {
            queue.add("");
        }
        while (!queue.isEmpty()) {
            String path = (String)queue.removeFirst();
            File currentDir = new File(dir, path);
            File[] files = currentDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String resource = path.length() > 0 ? path + "/" + file.getName() : file.getName();
                if (file.isDirectory()) {
                    queue.add(resource);
                    continue;
                }
                wagon.put(file, resource);
            }
        }
    }
}

