/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.as.issuer;

import java.security.MessageDigest;
import java.util.UUID;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class MD5Generator
implements ValueGenerator {
    private static final char[] hexCode = "0123456789abcdef".toCharArray();

    @Override
    public String generateValue() throws OAuthSystemException {
        return this.generateValue(UUID.randomUUID().toString());
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }

    @Override
    public String generateValue(String param) throws OAuthSystemException {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(param.getBytes());
            byte[] messageDigest = algorithm.digest();
            return MD5Generator.toHexString(messageDigest);
        }
        catch (Exception e) {
            throw new OAuthSystemException("OAuth Token cannot be generated.", (Throwable)e);
        }
    }
}

