/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.postag.ConfigurablePOSContextGenerator;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.DefaultPOSSequenceValidator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Version;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;

public class POSTaggerFactory
extends BaseToolFactory {
    private static final String TAG_DICTIONARY_ENTRY_NAME = "tags.tagdict";
    private static final String NGRAM_DICTIONARY_ENTRY_NAME = "ngram.dictionary";
    protected Dictionary ngramDictionary;
    private byte[] featureGeneratorBytes;
    private Map<String, Object> resources;
    protected TagDictionary posDictionary;

    public POSTaggerFactory() {
    }

    public POSTaggerFactory(byte[] featureGeneratorBytes, Map<String, Object> resources, TagDictionary posDictionary) {
        this.featureGeneratorBytes = featureGeneratorBytes;
        if (this.featureGeneratorBytes == null) {
            this.featureGeneratorBytes = POSTaggerFactory.loadDefaultFeatureGeneratorBytes();
        }
        this.resources = resources;
        this.posDictionary = posDictionary;
    }

    @Deprecated(forRemoval=true)
    POSTaggerFactory(Dictionary ngramDictionary, TagDictionary posDictionary) {
        this.init(ngramDictionary, posDictionary);
    }

    @Deprecated(forRemoval=true)
    void init(Dictionary ngramDictionary, TagDictionary posDictionary) {
        this.ngramDictionary = ngramDictionary;
        this.posDictionary = posDictionary;
    }

    protected void init(byte[] featureGeneratorBytes, Map<String, Object> resources, TagDictionary posDictionary) {
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.posDictionary = posDictionary;
    }

    private static byte[] loadDefaultFeatureGeneratorBytes() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        InputStream resource = POSTaggerFactory.class.getResourceAsStream("/opennlp/tools/postag/pos-default-features.xml");
        if (resource == null) {
            throw new IllegalStateException("Classpath must contain 'pos-default-features.xml' file!");
        }
        try (BufferedInputStream in = new BufferedInputStream(resource);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                bytes.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed reading from 'pos-default-features.xml' file on classpath!");
        }
        return bytes.toByteArray();
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        AdaptiveFeatureGenerator generator;
        if (this.featureGeneratorBytes == null && this.artifactProvider != null) {
            this.featureGeneratorBytes = (byte[])this.artifactProvider.getArtifact("generator.featuregen");
        }
        if (this.featureGeneratorBytes == null) {
            this.featureGeneratorBytes = POSTaggerFactory.loadDefaultFeatureGeneratorBytes();
        }
        try (ByteArrayInputStream descriptorIn = new ByteArrayInputStream(this.featureGeneratorBytes);){
            generator = GeneratorFactory.create(descriptorIn, (String key) -> {
                if (this.artifactProvider != null) {
                    return this.artifactProvider.getArtifact(key);
                }
                return this.resources.get(key);
            });
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading from mem cannot result in an I/O error", e);
        }
        return generator;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        POSDictionarySerializer.register(serializers);
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.posDictionary != null) {
            artifactMap.put(TAG_DICTIONARY_ENTRY_NAME, this.posDictionary);
        }
        if (this.ngramDictionary != null) {
            artifactMap.put(NGRAM_DICTIONARY_ENTRY_NAME, this.ngramDictionary);
        }
        return artifactMap;
    }

    public TagDictionary createTagDictionary(File dictionary) throws IOException {
        return this.createTagDictionary(new BufferedInputStream(new FileInputStream(dictionary)));
    }

    public TagDictionary createTagDictionary(InputStream in) throws IOException {
        return POSDictionary.create(in);
    }

    public void setTagDictionary(TagDictionary dictionary) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set tag dictionary while using artifact provider.");
        }
        this.posDictionary = dictionary;
    }

    protected Map<String, Object> getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        return Collections.emptyMap();
    }

    protected byte[] getFeatureGenerator() {
        return this.featureGeneratorBytes;
    }

    public TagDictionary getTagDictionary() {
        if (this.posDictionary == null && this.artifactProvider != null) {
            this.posDictionary = (TagDictionary)this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        }
        return this.posDictionary;
    }

    @Deprecated(forRemoval=true)
    private Dictionary getDictionary() {
        if (this.ngramDictionary == null && this.artifactProvider != null) {
            this.ngramDictionary = (Dictionary)this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME);
        }
        return this.ngramDictionary;
    }

    public POSContextGenerator getPOSContextGenerator() {
        return this.getPOSContextGenerator(0);
    }

    public POSContextGenerator getPOSContextGenerator(int cacheSize) {
        Properties manifest;
        String version;
        Version v;
        if (this.artifactProvider != null && (v = Version.parse(version = (manifest = (Properties)this.artifactProvider.getArtifact("manifest.properties")).getProperty("OpenNLP-Version"))).getMajor() == 1 && v.getMinor() < 8) {
            return new DefaultPOSContextGenerator(cacheSize, this.getDictionary());
        }
        return new ConfigurablePOSContextGenerator(cacheSize, this.createFeatureGenerators());
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DefaultPOSSequenceValidator(this.getTagDictionary());
    }

    protected void validatePOSDictionary(POSDictionary posDict, AbstractModel posModel) throws InvalidFormatException {
        HashSet dictTags = new HashSet();
        for (String word : posDict) {
            Collections.addAll(dictTags, posDict.getTags(word));
        }
        HashSet<String> modelTags = new HashSet<String>();
        for (int i = 0; i < posModel.getNumOutcomes(); ++i) {
            modelTags.add(posModel.getOutcome(i));
        }
        if (!modelTags.containsAll(dictTags)) {
            StringBuilder unknownTag = new StringBuilder();
            for (String d : dictTags) {
                if (modelTags.contains(d)) continue;
                unknownTag.append(d).append(" ");
            }
            throw new InvalidFormatException("Tag dictionary contains tags which are unknown by the model! The unknown tags are: " + unknownTag);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        Object ngramDictEntry;
        Object tagdictEntry = this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        if (tagdictEntry != null) {
            if (tagdictEntry instanceof POSDictionary) {
                if (!this.artifactProvider.isLoadedFromSerialized()) {
                    AbstractModel posModel = (AbstractModel)this.artifactProvider.getArtifact("pos.model");
                    POSDictionary posDict = (POSDictionary)tagdictEntry;
                    this.validatePOSDictionary(posDict, posModel);
                }
            } else {
                throw new InvalidFormatException("POSTag dictionary has wrong type!");
            }
        }
        if ((ngramDictEntry = this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME)) != null && !(ngramDictEntry instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }

    @Deprecated
    static POSTaggerFactory create(String subclassName, Dictionary ngramDictionary, TagDictionary posDictionary) throws InvalidFormatException {
        if (subclassName == null) {
            return new POSTaggerFactory(ngramDictionary, posDictionary);
        }
        try {
            POSTaggerFactory theFactory = ExtensionLoader.instantiateExtension(POSTaggerFactory.class, subclassName);
            theFactory.init(ngramDictionary, posDictionary);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            throw new InvalidFormatException(msg, e);
        }
    }

    public static POSTaggerFactory create(String subclassName, byte[] featureGeneratorBytes, Map<String, Object> resources, TagDictionary posDictionary) throws InvalidFormatException {
        POSTaggerFactory theFactory;
        if (subclassName == null) {
            theFactory = new POSTaggerFactory();
            theFactory.init(featureGeneratorBytes, resources, posDictionary);
        } else {
            try {
                theFactory = ExtensionLoader.instantiateExtension(POSTaggerFactory.class, subclassName);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
                throw new InvalidFormatException(msg, e);
            }
        }
        theFactory.init(featureGeneratorBytes, resources, posDictionary);
        return theFactory;
    }

    public TagDictionary createEmptyTagDictionary() {
        this.posDictionary = new POSDictionary(true);
        return this.posDictionary;
    }

    public static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        @Override
        public POSDictionary create(InputStream in) throws IOException {
            return POSDictionary.create(new UncloseableInputStream(in));
        }

        @Override
        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new POSDictionarySerializer());
        }
    }
}

