/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column;

import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.impl.ColumnWriteStoreV2;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import org.apache.parquet.column.values.factory.DefaultValuesWriterFactory;
import org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.apache.parquet.schema.MessageType;

public class ParquetProperties {
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final int DEFAULT_DICTIONARY_PAGE_SIZE = 0x100000;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final WriterVersion DEFAULT_WRITER_VERSION = WriterVersion.PARQUET_1_0;
    public static final boolean DEFAULT_ESTIMATE_ROW_COUNT_FOR_PAGE_SIZE_CHECK = true;
    public static final int DEFAULT_MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    public static final int DEFAULT_MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    public static final ValuesWriterFactory DEFAULT_VALUES_WRITER_FACTORY = new DefaultValuesWriterFactory();
    private static final int MIN_SLAB_SIZE = 64;
    private final int initialSlabSize;
    private final int pageSizeThreshold;
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;
    private final int minRowCountForPageSizeCheck;
    private final int maxRowCountForPageSizeCheck;
    private final boolean estimateNextSizeCheck;
    private final ByteBufferAllocator allocator;
    private final ValuesWriterFactory valuesWriterFactory;

    private ParquetProperties(WriterVersion writerVersion, int pageSize, int dictPageSize, boolean enableDict, int minRowCountForPageSizeCheck, int maxRowCountForPageSizeCheck, boolean estimateNextSizeCheck, ByteBufferAllocator allocator, ValuesWriterFactory writerFactory) {
        this.pageSizeThreshold = pageSize;
        this.initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic((int)64, (int)this.pageSizeThreshold, (int)10);
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
        this.minRowCountForPageSizeCheck = minRowCountForPageSizeCheck;
        this.maxRowCountForPageSizeCheck = maxRowCountForPageSizeCheck;
        this.estimateNextSizeCheck = estimateNextSizeCheck;
        this.allocator = allocator;
        this.valuesWriterFactory = writerFactory;
    }

    public ValuesWriter newRepetitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxRepetitionLevel());
    }

    public ValuesWriter newDefinitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxDefinitionLevel());
    }

    private ValuesWriter newColumnDescriptorValuesWriter(int maxLevel) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt((int)maxLevel), 64, this.pageSizeThreshold, this.allocator);
    }

    public RunLengthBitPackingHybridEncoder newRepetitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxRepetitionLevel());
    }

    public RunLengthBitPackingHybridEncoder newDefinitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxDefinitionLevel());
    }

    private RunLengthBitPackingHybridEncoder newLevelEncoder(int maxLevel) {
        return new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), 64, this.pageSizeThreshold, this.allocator);
    }

    public ValuesWriter newValuesWriter(ColumnDescriptor path) {
        return this.valuesWriterFactory.newValuesWriter(path);
    }

    public int getPageSizeThreshold() {
        return this.pageSizeThreshold;
    }

    public int getInitialSlabSize() {
        return this.initialSlabSize;
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public ByteBufferAllocator getAllocator() {
        return this.allocator;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(pageStore, this);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, this);
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public int getMinRowCountForPageSizeCheck() {
        return this.minRowCountForPageSizeCheck;
    }

    public int getMaxRowCountForPageSizeCheck() {
        return this.maxRowCountForPageSizeCheck;
    }

    public ValuesWriterFactory getValuesWriterFactory() {
        return this.valuesWriterFactory;
    }

    public boolean estimateNextSizeCheck() {
        return this.estimateNextSizeCheck;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(ParquetProperties toCopy) {
        return new Builder(toCopy);
    }

    public static class Builder {
        private int pageSize = 0x100000;
        private int dictPageSize = 0x100000;
        private boolean enableDict = true;
        private WriterVersion writerVersion = DEFAULT_WRITER_VERSION;
        private int minRowCountForPageSizeCheck = 100;
        private int maxRowCountForPageSizeCheck = 10000;
        private boolean estimateNextSizeCheck = true;
        private ByteBufferAllocator allocator = new HeapByteBufferAllocator();
        private ValuesWriterFactory valuesWriterFactory = DEFAULT_VALUES_WRITER_FACTORY;

        private Builder() {
        }

        private Builder(ParquetProperties toCopy) {
            this.enableDict = toCopy.enableDictionary;
            this.dictPageSize = toCopy.dictionaryPageSizeThreshold;
            this.writerVersion = toCopy.writerVersion;
            this.minRowCountForPageSizeCheck = toCopy.minRowCountForPageSizeCheck;
            this.maxRowCountForPageSizeCheck = toCopy.maxRowCountForPageSizeCheck;
            this.estimateNextSizeCheck = toCopy.estimateNextSizeCheck;
            this.allocator = toCopy.allocator;
        }

        public Builder withPageSize(int pageSize) {
            Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (String)"Invalid page size (negative): %s", (Object[])new Object[]{pageSize});
            this.pageSize = pageSize;
            return this;
        }

        public Builder withDictionaryEncoding(boolean enableDictionary) {
            this.enableDict = enableDictionary;
            return this;
        }

        public Builder withDictionaryPageSize(int dictionaryPageSize) {
            Preconditions.checkArgument((dictionaryPageSize > 0 ? 1 : 0) != 0, (String)"Invalid dictionary page size (negative): %s", (Object[])new Object[]{dictionaryPageSize});
            this.dictPageSize = dictionaryPageSize;
            return this;
        }

        public Builder withWriterVersion(WriterVersion version) {
            this.writerVersion = version;
            return this;
        }

        public Builder withMinRowCountForPageSizeCheck(int min) {
            Preconditions.checkArgument((min > 0 ? 1 : 0) != 0, (String)"Invalid row count for page size check (negative): %s", (Object[])new Object[]{min});
            this.minRowCountForPageSizeCheck = min;
            return this;
        }

        public Builder withMaxRowCountForPageSizeCheck(int max) {
            Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (String)"Invalid row count for page size check (negative): %s", (Object[])new Object[]{max});
            this.maxRowCountForPageSizeCheck = max;
            return this;
        }

        public Builder estimateRowCountForPageSizeCheck(boolean estimateNextSizeCheck) {
            this.estimateNextSizeCheck = estimateNextSizeCheck;
            return this;
        }

        public Builder withAllocator(ByteBufferAllocator allocator) {
            Preconditions.checkNotNull((Object)allocator, (String)"ByteBufferAllocator");
            this.allocator = allocator;
            return this;
        }

        public Builder withValuesWriterFactory(ValuesWriterFactory factory) {
            Preconditions.checkNotNull((Object)factory, (String)"ValuesWriterFactory");
            this.valuesWriterFactory = factory;
            return this;
        }

        public ParquetProperties build() {
            ParquetProperties properties = new ParquetProperties(this.writerVersion, this.pageSize, this.dictPageSize, this.enableDict, this.minRowCountForPageSizeCheck, this.maxRowCountForPageSizeCheck, this.estimateNextSizeCheck, this.allocator, this.valuesWriterFactory);
            this.valuesWriterFactory.initialize(properties);
            return properties;
        }
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

