/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.compat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.dictionarylevel.DictionaryFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.SchemaCompatibilityValidator;
import org.apache.parquet.filter2.statisticslevel.StatisticsFilter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.schema.MessageType;

public class RowGroupFilter
implements FilterCompat.Visitor<List<BlockMetaData>> {
    private final List<BlockMetaData> blocks;
    private final MessageType schema;
    private final List<FilterLevel> levels;
    private final ParquetFileReader reader;

    @Deprecated
    public static List<BlockMetaData> filterRowGroups(FilterCompat.Filter filter, List<BlockMetaData> blocks, MessageType schema) {
        Preconditions.checkNotNull((Object)filter, (String)"filter");
        return (List)filter.accept((FilterCompat.Visitor)new RowGroupFilter(blocks, schema));
    }

    public static List<BlockMetaData> filterRowGroups(List<FilterLevel> levels, FilterCompat.Filter filter, List<BlockMetaData> blocks, ParquetFileReader reader) {
        Preconditions.checkNotNull((Object)filter, (String)"filter");
        return (List)filter.accept((FilterCompat.Visitor)new RowGroupFilter(levels, blocks, reader));
    }

    @Deprecated
    private RowGroupFilter(List<BlockMetaData> blocks, MessageType schema) {
        this.blocks = (List)Preconditions.checkNotNull(blocks, (String)"blocks");
        this.schema = (MessageType)Preconditions.checkNotNull((Object)schema, (String)"schema");
        this.levels = Collections.singletonList(FilterLevel.STATISTICS);
        this.reader = null;
    }

    private RowGroupFilter(List<FilterLevel> levels, List<BlockMetaData> blocks, ParquetFileReader reader) {
        this.blocks = (List)Preconditions.checkNotNull(blocks, (String)"blocks");
        this.reader = (ParquetFileReader)Preconditions.checkNotNull((Object)reader, (String)"reader");
        this.schema = reader.getFileMetaData().getSchema();
        this.levels = levels;
    }

    public List<BlockMetaData> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
        FilterPredicate filterPredicate = filterPredicateCompat.getFilterPredicate();
        SchemaCompatibilityValidator.validate((FilterPredicate)filterPredicate, (MessageType)this.schema);
        ArrayList<BlockMetaData> filteredBlocks = new ArrayList<BlockMetaData>();
        for (BlockMetaData block : this.blocks) {
            boolean drop = false;
            if (this.levels.contains((Object)FilterLevel.STATISTICS)) {
                drop = StatisticsFilter.canDrop(filterPredicate, block.getColumns());
            }
            if (!drop && this.levels.contains((Object)FilterLevel.DICTIONARY)) {
                drop = DictionaryFilter.canDrop(filterPredicate, block.getColumns(), this.reader.getDictionaryReader(block));
            }
            if (drop) continue;
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    public List<BlockMetaData> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
        return this.blocks;
    }

    public List<BlockMetaData> visit(FilterCompat.NoOpFilter noOpFilter) {
        return this.blocks;
    }

    public static enum FilterLevel {
        STATISTICS,
        DICTIONARY;

    }
}

