/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalParquetRecordWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalParquetRecordWriter.class);
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    private static final int MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    private final ParquetFileWriter parquetFileWriter;
    private final WriteSupport<T> writeSupport;
    private final MessageType schema;
    private final Map<String, String> extraMetaData;
    private final long rowGroupSize;
    private long rowGroupSizeThreshold;
    private long nextRowGroupSize;
    private final CodecFactory.BytesCompressor compressor;
    private final boolean validating;
    private final ParquetProperties props;
    private boolean closed;
    private long recordCount = 0L;
    private long recordCountForNextMemCheck = 100L;
    private long lastRowGroupEndPos = 0L;
    private ColumnWriteStore columnStore;
    private ColumnChunkPageWriteStore pageStore;
    private RecordConsumer recordConsumer;

    public InternalParquetRecordWriter(ParquetFileWriter parquetFileWriter, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long rowGroupSize, CodecFactory.BytesCompressor compressor, boolean validating, ParquetProperties props) {
        this.parquetFileWriter = parquetFileWriter;
        this.writeSupport = (WriteSupport)Preconditions.checkNotNull(writeSupport, (String)"writeSupport");
        this.schema = schema;
        this.extraMetaData = extraMetaData;
        this.rowGroupSize = rowGroupSize;
        this.nextRowGroupSize = this.rowGroupSizeThreshold = rowGroupSize;
        this.compressor = compressor;
        this.validating = validating;
        this.props = props;
        this.initStore();
    }

    public ParquetMetadata getFooter() {
        return this.parquetFileWriter.getFooter();
    }

    private void initStore() {
        this.pageStore = new ColumnChunkPageWriteStore(this.compressor, this.schema, this.props.getAllocator());
        this.columnStore = this.props.newColumnWriteStore(this.schema, (PageWriteStore)this.pageStore);
        MessageColumnIO columnIO = new ColumnIOFactory(this.validating).getColumnIO(this.schema);
        this.recordConsumer = columnIO.getRecordWriter(this.columnStore);
        this.writeSupport.prepareForWrite(this.recordConsumer);
    }

    public void close() throws IOException, InterruptedException {
        if (!this.closed) {
            this.flushRowGroupToStore();
            WriteSupport.FinalizedWriteContext finalWriteContext = this.writeSupport.finalizeWrite();
            HashMap<String, String> finalMetadata = new HashMap<String, String>(this.extraMetaData);
            String modelName = this.writeSupport.getName();
            if (modelName != null) {
                finalMetadata.put("writer.model.name", modelName);
            }
            finalMetadata.putAll(finalWriteContext.getExtraMetaData());
            this.parquetFileWriter.end(finalMetadata);
            this.closed = true;
        }
    }

    public void write(T value) throws IOException, InterruptedException {
        this.writeSupport.write(value);
        ++this.recordCount;
        this.checkBlockSizeReached();
    }

    public long getDataSize() {
        return this.lastRowGroupEndPos + this.columnStore.getBufferedSize();
    }

    private void checkBlockSizeReached() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long recordSize;
            long memSize = this.columnStore.getBufferedSize();
            if (memSize > this.nextRowGroupSize - 2L * (recordSize = memSize / this.recordCount)) {
                LOG.info("mem size {} > {}: flushing {} records to disk.", new Object[]{memSize, this.nextRowGroupSize, this.recordCount});
                this.flushRowGroupToStore();
                this.initStore();
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, this.recordCount / 2L), 10000L);
                this.lastRowGroupEndPos = this.parquetFileWriter.getPos();
            } else {
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, (this.recordCount + (long)((float)this.nextRowGroupSize / (float)recordSize)) / 2L), this.recordCount + 10000L);
                LOG.debug("Checked mem at {} will check again at: {}", (Object)this.recordCount, (Object)this.recordCountForNextMemCheck);
            }
        }
    }

    private void flushRowGroupToStore() throws IOException {
        this.recordConsumer.flush();
        LOG.info("Flushing mem columnStore to file. allocated memory: {}", (Object)this.columnStore.getAllocatedSize());
        if (this.columnStore.getAllocatedSize() > 3L * this.rowGroupSizeThreshold) {
            LOG.warn("Too much memory used: {}", (Object)this.columnStore.memUsageString());
        }
        if (this.recordCount > 0L) {
            this.parquetFileWriter.startBlock(this.recordCount);
            this.columnStore.flush();
            this.pageStore.flushToFileWriter(this.parquetFileWriter);
            this.recordCount = 0L;
            this.parquetFileWriter.endBlock();
            this.nextRowGroupSize = Math.min(this.parquetFileWriter.getNextRowGroupSize(), this.rowGroupSizeThreshold);
        }
        this.columnStore = null;
        this.pageStore = null;
    }

    long getRowGroupSizeThreshold() {
        return this.rowGroupSizeThreshold;
    }

    void setRowGroupSizeThreshold(long rowGroupSizeThreshold) {
        this.rowGroupSizeThreshold = rowGroupSizeThreshold;
    }

    MessageType getSchema() {
        return this.schema;
    }
}

