/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.model.CalculationChain;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;

public class XSSFRow
implements Row,
Comparable<XSSFRow> {
    private final CTRow _row;
    private final TreeMap<Integer, XSSFCell> _cells;
    private final XSSFSheet _sheet;

    protected XSSFRow(CTRow row, XSSFSheet sheet) {
        this._row = row;
        this._sheet = sheet;
        this._cells = new TreeMap();
        for (CTCell c : row.getCArray()) {
            XSSFCell cell = new XSSFCell(this, c);
            Integer colI = new Integer(cell.getColumnIndex());
            this._cells.put(colI, cell);
            sheet.onReadCell(cell);
        }
        if (!row.isSetR()) {
            int nextRowNum = sheet.getLastRowNum() + 2;
            if (nextRowNum == 2 && sheet.getPhysicalNumberOfRows() == 0) {
                nextRowNum = 1;
            }
            row.setR((long)nextRowNum);
        }
    }

    public XSSFSheet getSheet() {
        return this._sheet;
    }

    public Iterator<Cell> cellIterator() {
        return this._cells.values().iterator();
    }

    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    @Override
    public int compareTo(XSSFRow other) {
        if (this.getSheet() != other.getSheet()) {
            throw new IllegalArgumentException("The compared rows must belong to the same sheet");
        }
        Integer thisRow = this.getRowNum();
        Integer otherRow = other.getRowNum();
        return thisRow.compareTo(otherRow);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XSSFRow)) {
            return false;
        }
        XSSFRow other = (XSSFRow)obj;
        return this.getRowNum() == other.getRowNum() && this.getSheet() == other.getSheet();
    }

    public int hashCode() {
        return this._row.hashCode();
    }

    public XSSFCell createCell(int columnIndex) {
        return this.createCell(columnIndex, 3);
    }

    public XSSFCell createCell(int columnIndex, int type) {
        CTCell ctCell;
        Integer colI = new Integer(columnIndex);
        XSSFCell prev = this._cells.get(colI);
        if (prev != null) {
            ctCell = prev.getCTCell();
            ctCell.set((XmlObject)CTCell.Factory.newInstance());
        } else {
            ctCell = this._row.addNewC();
        }
        XSSFCell xcell = new XSSFCell(this, ctCell);
        xcell.setCellNum(columnIndex);
        if (type != 3) {
            xcell.setCellType(type);
        }
        this._cells.put(colI, xcell);
        return xcell;
    }

    public XSSFCell getCell(int cellnum) {
        return this.getCell(cellnum, this._sheet.getWorkbook().getMissingCellPolicy());
    }

    public XSSFCell getCell(int cellnum, Row.MissingCellPolicy policy) {
        if (cellnum < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        Integer colI = new Integer(cellnum);
        XSSFCell cell = this._cells.get(colI);
        switch (policy) {
            case RETURN_NULL_AND_BLANK: {
                return cell;
            }
            case RETURN_BLANK_AS_NULL: {
                boolean isBlank = cell != null && cell.getCellType() == 3;
                return isBlank ? null : cell;
            }
            case CREATE_NULL_AS_BLANK: {
                return cell == null ? this.createCell(cellnum, 3) : cell;
            }
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public short getFirstCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.firstKey());
    }

    public short getLastCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.lastKey() + 1);
    }

    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    public float getHeightInPoints() {
        if (this._row.isSetHt()) {
            return (float)this._row.getHt();
        }
        return this._sheet.getDefaultRowHeightInPoints();
    }

    public void setHeight(short height) {
        if (height == -1) {
            if (this._row.isSetHt()) {
                this._row.unsetHt();
            }
            if (this._row.isSetCustomHeight()) {
                this._row.unsetCustomHeight();
            }
        } else {
            this._row.setHt((double)height / 20.0);
            this._row.setCustomHeight(true);
        }
    }

    public void setHeightInPoints(float height) {
        this.setHeight((short)(height == -1.0f ? -1.0f : height * 20.0f));
    }

    public int getPhysicalNumberOfCells() {
        return this._cells.size();
    }

    public int getRowNum() {
        return (int)(this._row.getR() - 1L);
    }

    public void setRowNum(int rowIndex) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rowIndex + ") outside allowable range (0.." + maxrow + ")");
        }
        this._row.setR((long)(rowIndex + 1));
    }

    public boolean getZeroHeight() {
        return this._row.getHidden();
    }

    public void setZeroHeight(boolean height) {
        this._row.setHidden(height);
    }

    public boolean isFormatted() {
        return this._row.isSetS();
    }

    public XSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        StylesTable stylesSource = this.getSheet().getWorkbook().getStylesSource();
        if (stylesSource.getNumCellStyles() > 0) {
            return stylesSource.getStyleAt((int)this._row.getS());
        }
        return null;
    }

    public void setRowStyle(CellStyle style) {
        if (style == null) {
            if (this._row.isSetS()) {
                this._row.unsetS();
                this._row.unsetCustomFormat();
            }
        } else {
            StylesTable styleSource = this.getSheet().getWorkbook().getStylesSource();
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            xStyle.verifyBelongsToStylesSource(styleSource);
            long idx = styleSource.putStyle(xStyle);
            this._row.setS(idx);
            this._row.setCustomFormat(true);
        }
    }

    public void removeCell(Cell cell) {
        if (cell.getRow() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this row");
        }
        XSSFCell xcell = (XSSFCell)cell;
        if (xcell.isPartOfArrayFormulaGroup()) {
            xcell.notifyArrayFormulaChanging();
        }
        if (cell.getCellType() == 2) {
            this._sheet.getWorkbook().onDeleteFormula(xcell);
        }
        Integer colI = new Integer(cell.getColumnIndex());
        this._cells.remove(colI);
    }

    @Internal
    public CTRow getCTRow() {
        return this._row;
    }

    protected void onDocumentWrite() {
        int i;
        boolean isOrdered = true;
        CTCell[] cArray = this._row.getCArray();
        if (cArray.length != this._cells.size()) {
            isOrdered = false;
        } else {
            i = 0;
            for (XSSFCell cell : this._cells.values()) {
                CTCell c1 = cell.getCTCell();
                CTCell c2 = cArray[i++];
                String r1 = c1.getR();
                String r2 = c2.getR();
                if (r1 != null ? r1.equals(r2) : r2 == null) continue;
                isOrdered = false;
                break;
            }
        }
        if (!isOrdered) {
            cArray = new CTCell[this._cells.size()];
            i = 0;
            for (XSSFCell xssfCell : this._cells.values()) {
                cArray[i] = (CTCell)xssfCell.getCTCell().copy();
                xssfCell.setCTCell(cArray[i]);
                ++i;
            }
            this._row.setCArray(cArray);
        }
    }

    public String toString() {
        return this._row.toString();
    }

    protected void shift(int n) {
        int rownum = this.getRowNum() + n;
        CalculationChain calcChain = this._sheet.getWorkbook().getCalculationChain();
        int sheetId = (int)this._sheet.sheet.getSheetId();
        String msg = "Row[rownum=" + this.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        Iterator<Cell> i$ = this.iterator();
        while (i$.hasNext()) {
            Cell c = i$.next();
            XSSFCell cell = (XSSFCell)c;
            if (cell.isPartOfArrayFormulaGroup()) {
                cell.notifyArrayFormulaChanging(msg);
            }
            if (calcChain != null) {
                calcChain.removeItem(sheetId, cell.getReference());
            }
            CTCell ctCell = cell.getCTCell();
            String r = new CellReference(rownum, cell.getColumnIndex()).formatAsString();
            ctCell.setR(r);
        }
        this.setRowNum(rownum);
    }

    public void copyRowFrom(Row srcRow, CellCopyPolicy policy) {
        if (srcRow == null) {
            Iterator<Cell> i$ = this.iterator();
            while (i$.hasNext()) {
                Cell destCell = i$.next();
                Cell srcCell = null;
                ((XSSFCell)destCell).copyCellFrom(srcCell, policy);
            }
            if (policy.isCopyMergedRegions()) {
                int destRowNum = this.getRowNum();
                int index = 0;
                HashSet<Integer> indices = new HashSet<Integer>();
                for (CellRangeAddress destRegion : this.getSheet().getMergedRegions()) {
                    if (destRowNum == destRegion.getFirstRow() && destRowNum == destRegion.getLastRow()) {
                        indices.add(index);
                    }
                    ++index;
                }
                this.getSheet().removeMergedRegions(indices);
            }
            if (policy.isCopyRowHeight()) {
                this.setHeight((short)-1);
            }
        } else {
            for (Cell c : srcRow) {
                XSSFCell srcCell = (XSSFCell)c;
                XSSFCell destCell = this.createCell(srcCell.getColumnIndex(), srcCell.getCellType());
                destCell.copyCellFrom(srcCell, policy);
            }
            XSSFRowShifter rowShifter = new XSSFRowShifter(this._sheet);
            int sheetIndex = this._sheet.getWorkbook().getSheetIndex(this._sheet);
            String sheetName = this._sheet.getWorkbook().getSheetName(sheetIndex);
            int srcRowNum = srcRow.getRowNum();
            int destRowNum = this.getRowNum();
            int rowDifference = destRowNum - srcRowNum;
            FormulaShifter shifter = FormulaShifter.createForRowCopy((int)sheetIndex, (String)sheetName, (int)srcRowNum, (int)srcRowNum, (int)rowDifference, (SpreadsheetVersion)SpreadsheetVersion.EXCEL2007);
            rowShifter.updateRowFormulas(this, shifter);
            if (policy.isCopyMergedRegions()) {
                for (CellRangeAddress srcRegion : srcRow.getSheet().getMergedRegions()) {
                    if (srcRowNum != srcRegion.getFirstRow() || srcRowNum != srcRegion.getLastRow()) continue;
                    CellRangeAddress destRegion = srcRegion.copy();
                    destRegion.setFirstRow(destRowNum);
                    destRegion.setLastRow(destRowNum);
                    this.getSheet().addMergedRegion(destRegion);
                }
            }
            if (policy.isCopyRowHeight()) {
                this.setHeight(srcRow.getHeight());
            }
        }
    }

    public int getOutlineLevel() {
        return this._row.getOutlineLevel();
    }
}

