/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.lang.reflect.Method;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public class HSLFMetroShape<T extends Shape<?, ?>> {
    private static final POILogger LOGGER = POILogFactory.getLogger(HSLFMetroShape.class);
    private final HSLFShape shape;

    public HSLFMetroShape(HSLFShape shape) {
        this.shape = shape;
    }

    public byte[] getMetroBytes() {
        EscherComplexProperty ep;
        AbstractEscherOptRecord opt = (AbstractEscherOptRecord)this.shape.getEscherChild(-3806);
        if (opt != null && (ep = (EscherComplexProperty)opt.lookup(937)) != null) {
            return ep.getComplexData();
        }
        return null;
    }

    public T getShape() {
        byte[] metroBytes = this.getMetroBytes();
        if (metroBytes == null) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> ms = cl.loadClass("org.apache.poi.xslf.usermodel.XSLFMetroShape");
            Method m = ms.getMethod("parseShape", byte[].class);
            return (T)((Shape)m.invoke(null, new Object[]{metroBytes}));
        }
        catch (Exception e) {
            LOGGER.log(7, new Object[]{"can't process metro blob, check if all dependencies for POI OOXML are in the classpath.", e});
            return null;
        }
    }
}

