/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.LinkedList;
import java.util.List;
import org.apache.pulsar.common.policies.data.ExceptionInformation;

public class SinkStatus {
    public int numInstances;
    public int numRunning;
    public List<SinkInstanceStatus> instances = new LinkedList<SinkInstanceStatus>();

    public void addInstance(SinkInstanceStatus sinkInstanceStatus) {
        this.instances.add(sinkInstanceStatus);
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public int getNumRunning() {
        return this.numRunning;
    }

    public List<SinkInstanceStatus> getInstances() {
        return this.instances;
    }

    public void setNumInstances(int numInstances) {
        this.numInstances = numInstances;
    }

    public void setNumRunning(int numRunning) {
        this.numRunning = numRunning;
    }

    public void setInstances(List<SinkInstanceStatus> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkStatus)) {
            return false;
        }
        SinkStatus other = (SinkStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumInstances() != other.getNumInstances()) {
            return false;
        }
        if (this.getNumRunning() != other.getNumRunning()) {
            return false;
        }
        List<SinkInstanceStatus> this$instances = this.getInstances();
        List<SinkInstanceStatus> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumInstances();
        result = result * 59 + this.getNumRunning();
        List<SinkInstanceStatus> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "SinkStatus(numInstances=" + this.getNumInstances() + ", numRunning=" + this.getNumRunning() + ", instances=" + this.getInstances() + ")";
    }

    public static class SinkInstanceStatus {
        public int instanceId;
        public SinkInstanceStatusData status;

        public int getInstanceId() {
            return this.instanceId;
        }

        public SinkInstanceStatusData getStatus() {
            return this.status;
        }

        public void setInstanceId(int instanceId) {
            this.instanceId = instanceId;
        }

        public void setStatus(SinkInstanceStatusData status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SinkInstanceStatus)) {
                return false;
            }
            SinkInstanceStatus other = (SinkInstanceStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInstanceId() != other.getInstanceId()) {
                return false;
            }
            SinkInstanceStatusData this$status = this.getStatus();
            SinkInstanceStatusData other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SinkInstanceStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInstanceId();
            SinkInstanceStatusData $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            return result;
        }

        public String toString() {
            return "SinkStatus.SinkInstanceStatus(instanceId=" + this.getInstanceId() + ", status=" + this.getStatus() + ")";
        }

        public static class SinkInstanceStatusData {
            public boolean running;
            public String error;
            public long numRestarts;
            public long numReadFromPulsar;
            public long numSystemExceptions;
            public List<ExceptionInformation> latestSystemExceptions;
            public long numSinkExceptions;
            public List<ExceptionInformation> latestSinkExceptions;
            public long numWrittenToSink;
            public long lastReceivedTime;
            public String workerId;

            public boolean isRunning() {
                return this.running;
            }

            public String getError() {
                return this.error;
            }

            public long getNumRestarts() {
                return this.numRestarts;
            }

            public long getNumReadFromPulsar() {
                return this.numReadFromPulsar;
            }

            public long getNumSystemExceptions() {
                return this.numSystemExceptions;
            }

            public List<ExceptionInformation> getLatestSystemExceptions() {
                return this.latestSystemExceptions;
            }

            public long getNumSinkExceptions() {
                return this.numSinkExceptions;
            }

            public List<ExceptionInformation> getLatestSinkExceptions() {
                return this.latestSinkExceptions;
            }

            public long getNumWrittenToSink() {
                return this.numWrittenToSink;
            }

            public long getLastReceivedTime() {
                return this.lastReceivedTime;
            }

            public String getWorkerId() {
                return this.workerId;
            }

            public void setRunning(boolean running) {
                this.running = running;
            }

            public void setError(String error) {
                this.error = error;
            }

            public void setNumRestarts(long numRestarts) {
                this.numRestarts = numRestarts;
            }

            public void setNumReadFromPulsar(long numReadFromPulsar) {
                this.numReadFromPulsar = numReadFromPulsar;
            }

            public void setNumSystemExceptions(long numSystemExceptions) {
                this.numSystemExceptions = numSystemExceptions;
            }

            public void setLatestSystemExceptions(List<ExceptionInformation> latestSystemExceptions) {
                this.latestSystemExceptions = latestSystemExceptions;
            }

            public void setNumSinkExceptions(long numSinkExceptions) {
                this.numSinkExceptions = numSinkExceptions;
            }

            public void setLatestSinkExceptions(List<ExceptionInformation> latestSinkExceptions) {
                this.latestSinkExceptions = latestSinkExceptions;
            }

            public void setNumWrittenToSink(long numWrittenToSink) {
                this.numWrittenToSink = numWrittenToSink;
            }

            public void setLastReceivedTime(long lastReceivedTime) {
                this.lastReceivedTime = lastReceivedTime;
            }

            public void setWorkerId(String workerId) {
                this.workerId = workerId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SinkInstanceStatusData)) {
                    return false;
                }
                SinkInstanceStatusData other = (SinkInstanceStatusData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isRunning() != other.isRunning()) {
                    return false;
                }
                if (this.getNumRestarts() != other.getNumRestarts()) {
                    return false;
                }
                if (this.getNumReadFromPulsar() != other.getNumReadFromPulsar()) {
                    return false;
                }
                if (this.getNumSystemExceptions() != other.getNumSystemExceptions()) {
                    return false;
                }
                if (this.getNumSinkExceptions() != other.getNumSinkExceptions()) {
                    return false;
                }
                if (this.getNumWrittenToSink() != other.getNumWrittenToSink()) {
                    return false;
                }
                if (this.getLastReceivedTime() != other.getLastReceivedTime()) {
                    return false;
                }
                String this$error = this.getError();
                String other$error = other.getError();
                if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                    return false;
                }
                List<ExceptionInformation> this$latestSystemExceptions = this.getLatestSystemExceptions();
                List<ExceptionInformation> other$latestSystemExceptions = other.getLatestSystemExceptions();
                if (this$latestSystemExceptions == null ? other$latestSystemExceptions != null : !((Object)this$latestSystemExceptions).equals(other$latestSystemExceptions)) {
                    return false;
                }
                List<ExceptionInformation> this$latestSinkExceptions = this.getLatestSinkExceptions();
                List<ExceptionInformation> other$latestSinkExceptions = other.getLatestSinkExceptions();
                if (this$latestSinkExceptions == null ? other$latestSinkExceptions != null : !((Object)this$latestSinkExceptions).equals(other$latestSinkExceptions)) {
                    return false;
                }
                String this$workerId = this.getWorkerId();
                String other$workerId = other.getWorkerId();
                return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SinkInstanceStatusData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isRunning() ? 79 : 97);
                long $numRestarts = this.getNumRestarts();
                result = result * 59 + (int)($numRestarts >>> 32 ^ $numRestarts);
                long $numReadFromPulsar = this.getNumReadFromPulsar();
                result = result * 59 + (int)($numReadFromPulsar >>> 32 ^ $numReadFromPulsar);
                long $numSystemExceptions = this.getNumSystemExceptions();
                result = result * 59 + (int)($numSystemExceptions >>> 32 ^ $numSystemExceptions);
                long $numSinkExceptions = this.getNumSinkExceptions();
                result = result * 59 + (int)($numSinkExceptions >>> 32 ^ $numSinkExceptions);
                long $numWrittenToSink = this.getNumWrittenToSink();
                result = result * 59 + (int)($numWrittenToSink >>> 32 ^ $numWrittenToSink);
                long $lastReceivedTime = this.getLastReceivedTime();
                result = result * 59 + (int)($lastReceivedTime >>> 32 ^ $lastReceivedTime);
                String $error = this.getError();
                result = result * 59 + ($error == null ? 43 : $error.hashCode());
                List<ExceptionInformation> $latestSystemExceptions = this.getLatestSystemExceptions();
                result = result * 59 + ($latestSystemExceptions == null ? 43 : ((Object)$latestSystemExceptions).hashCode());
                List<ExceptionInformation> $latestSinkExceptions = this.getLatestSinkExceptions();
                result = result * 59 + ($latestSinkExceptions == null ? 43 : ((Object)$latestSinkExceptions).hashCode());
                String $workerId = this.getWorkerId();
                result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
                return result;
            }

            public String toString() {
                return "SinkStatus.SinkInstanceStatus.SinkInstanceStatusData(running=" + this.isRunning() + ", error=" + this.getError() + ", numRestarts=" + this.getNumRestarts() + ", numReadFromPulsar=" + this.getNumReadFromPulsar() + ", numSystemExceptions=" + this.getNumSystemExceptions() + ", latestSystemExceptions=" + this.getLatestSystemExceptions() + ", numSinkExceptions=" + this.getNumSinkExceptions() + ", latestSinkExceptions=" + this.getLatestSinkExceptions() + ", numWrittenToSink=" + this.getNumWrittenToSink() + ", lastReceivedTime=" + this.getLastReceivedTime() + ", workerId=" + this.getWorkerId() + ")";
            }
        }
    }
}

