/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.allocator;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PulsarByteBufAllocator {
    private static final Logger log = LoggerFactory.getLogger(PulsarByteBufAllocator.class);
    public static final String PULSAR_ALLOCATOR_POOLED = "pulsar.allocator.pooled";
    public static final String PULSAR_ALLOCATOR_EXIT_ON_OOM = "pulsar.allocator.exit_on_oom";
    public static final String PULSAR_ALLOCATOR_LEAK_DETECTION = "pulsar.allocator.leak_detection";
    public static final String PULSAR_ALLOCATOR_OUT_OF_MEMORY_POLICY = "pulsar.allocator.out_of_memory_policy";
    public static final ByteBufAllocator DEFAULT;
    private static final List<Consumer<OutOfMemoryError>> LISTENERS;

    public static void registerOOMListener(Consumer<OutOfMemoryError> listener) {
        LISTENERS.add(listener);
    }

    @VisibleForTesting
    static ByteBufAllocator createByteBufAllocator() {
        boolean isPooled = "true".equalsIgnoreCase(System.getProperty(PULSAR_ALLOCATOR_POOLED, "true"));
        boolean isExitOnOutOfMemory = "true".equalsIgnoreCase(System.getProperty(PULSAR_ALLOCATOR_EXIT_ON_OOM, "false"));
        OutOfMemoryPolicy outOfMemoryPolicy = OutOfMemoryPolicy.valueOf(System.getProperty(PULSAR_ALLOCATOR_OUT_OF_MEMORY_POLICY, "FallbackToHeap"));
        LeakDetectionPolicy leakDetectionPolicy = LeakDetectionPolicy.valueOf(System.getProperty(PULSAR_ALLOCATOR_LEAK_DETECTION, "Disabled"));
        if (log.isDebugEnabled()) {
            log.debug("Is Pooled: {} -- Exit on OOM: {}", (Object)isPooled, (Object)isExitOnOutOfMemory);
        }
        ByteBufAllocatorBuilder builder = ByteBufAllocatorBuilder.create().leakDetectionPolicy(leakDetectionPolicy).pooledAllocator(PooledByteBufAllocator.DEFAULT).outOfMemoryListener(oomException -> {
            LISTENERS.forEach(c -> {
                try {
                    c.accept(oomException);
                }
                catch (Throwable t) {
                    log.warn("Exception during OOM listener: {}", (Object)t.getMessage(), (Object)t);
                }
            });
            if (isExitOnOutOfMemory) {
                log.info("Exiting JVM process for OOM error: {}", (Object)oomException.getMessage(), oomException);
                Runtime.getRuntime().halt(1);
            }
        });
        if (isPooled) {
            builder.poolingPolicy(PoolingPolicy.PooledDirect);
        } else {
            builder.poolingPolicy(PoolingPolicy.UnpooledHeap);
        }
        builder.outOfMemoryPolicy(outOfMemoryPolicy);
        return builder.build();
    }

    private PulsarByteBufAllocator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LISTENERS = new CopyOnWriteArrayList<Consumer<OutOfMemoryError>>();
        DEFAULT = PulsarByteBufAllocator.createByteBufAllocator();
    }
}

