/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer.store;

import java.util.concurrent.atomic.AtomicLong;

public class ControllableOffset {
    private final AtomicLong value;
    private volatile boolean allowToUpdate;

    public ControllableOffset(long value) {
        this.value = new AtomicLong(value);
        this.allowToUpdate = true;
    }

    public void update(long target, boolean increaseOnly) {
        if (this.allowToUpdate) {
            this.value.getAndUpdate(val -> {
                if (this.allowToUpdate) {
                    if (increaseOnly) {
                        return Math.max(target, val);
                    }
                    return target;
                }
                return val;
            });
        }
    }

    public void update(long target) {
        this.update(target, false);
    }

    public void updateAndFreeze(long target) {
        this.value.getAndUpdate(val -> {
            this.allowToUpdate = false;
            return target;
        });
    }

    public long getOffset() {
        return this.value.get();
    }
}

