/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.compression.Compressor;
import org.apache.rocketmq.common.compression.CompressorFactory;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageVersion;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;

public class MessageDecoder {
    public static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    public static final int MESSAGE_MAGIC_CODE_POSITION = 4;
    public static final int MESSAGE_FLAG_POSITION = 16;
    public static final int MESSAGE_PHYSIC_OFFSET_POSITION = 28;
    public static final int MESSAGE_STORE_TIMESTAMP_POSITION = 56;
    public static final int MESSAGE_MAGIC_CODE = -626843481;
    public static final int MESSAGE_MAGIC_CODE_V2 = -626843477;
    public static final int BLANK_MAGIC_CODE = -875286124;
    public static final char NAME_VALUE_SEPARATOR = '\u0001';
    public static final char PROPERTY_SEPARATOR = '\u0002';
    public static final int PHY_POS_POSITION = 28;
    public static final int QUEUE_OFFSET_POSITION = 20;
    public static final int SYSFLAG_POSITION = 36;

    public static String createMessageId(ByteBuffer input, ByteBuffer addr, long offset) {
        input.flip();
        int msgIDLength = addr.limit() == 8 ? 16 : 28;
        input.limit(msgIDLength);
        input.put(addr);
        input.putLong(offset);
        return UtilAll.bytes2string(input.array());
    }

    public static String createMessageId(SocketAddress socketAddress, long transactionIdhashCode) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        int msgIDLength = inetSocketAddress.getAddress() instanceof Inet4Address ? 16 : 28;
        ByteBuffer byteBuffer = ByteBuffer.allocate(msgIDLength);
        byteBuffer.put(inetSocketAddress.getAddress().getAddress());
        byteBuffer.putInt(inetSocketAddress.getPort());
        byteBuffer.putLong(transactionIdhashCode);
        byteBuffer.flip();
        return UtilAll.bytes2string(byteBuffer.array());
    }

    public static MessageId decodeMessageId(String msgId) throws UnknownHostException {
        byte[] bytes = UtilAll.string2bytes(msgId);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byte[] ip = new byte[msgId.length() == 32 ? 4 : 16];
        byteBuffer.get(ip);
        int port = byteBuffer.getInt();
        InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(ip), port);
        long offset = byteBuffer.getLong();
        return new MessageId(address, offset);
    }

    public static Map<String, String> decodeProperties(ByteBuffer byteBuffer) {
        int sysFlag = byteBuffer.getInt(36);
        int magicCode = byteBuffer.getInt(4);
        MessageVersion version = MessageVersion.valueOfMagicCode(magicCode);
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int storehostAddressLength = (sysFlag & 0x20) == 0 ? 8 : 20;
        int bodySizePosition = 48 + bornhostLength + 8 + storehostAddressLength + 4 + 8;
        int topicLengthPosition = bodySizePosition + 4 + byteBuffer.getInt(bodySizePosition);
        byteBuffer.position(topicLengthPosition);
        int topicLengthSize = version.getTopicLengthSize();
        int topicLength = version.getTopicLength(byteBuffer);
        int propertiesPosition = topicLengthPosition + topicLengthSize + topicLength;
        short propertiesLength = byteBuffer.getShort(propertiesPosition);
        byteBuffer.position(propertiesPosition + 2);
        if (propertiesLength > 0) {
            byte[] properties = new byte[propertiesLength];
            byteBuffer.get(properties);
            String propertiesString = new String(properties, CHARSET_UTF8);
            return MessageDecoder.string2messageProperties(propertiesString);
        }
        return null;
    }

    public static void createCrc32(ByteBuffer input, int crc32) {
        input.put("__CRC32#".getBytes(StandardCharsets.UTF_8));
        input.put((byte)1);
        for (int i = 0; i < 10; ++i) {
            byte b = 48;
            if (crc32 > 0) {
                b = (byte)(b + (byte)(crc32 % 10));
                crc32 /= 10;
            }
            input.put(b);
        }
        input.put((byte)2);
    }

    public static void createCrc32(ByteBuf input, int crc32) {
        input.writeBytes("__CRC32#".getBytes(StandardCharsets.UTF_8));
        input.writeByte(1);
        for (int i = 0; i < 10; ++i) {
            int b = 48;
            if (crc32 > 0) {
                b = (byte)(b + (byte)(crc32 % 10));
                crc32 /= 10;
            }
            input.writeByte(b);
        }
        input.writeByte(2);
    }

    public static MessageExt decode(ByteBuffer byteBuffer) {
        return MessageDecoder.decode(byteBuffer, true, true, false);
    }

    public static MessageExt clientDecode(ByteBuffer byteBuffer, boolean readBody) {
        return MessageDecoder.decode(byteBuffer, readBody, true, true);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody) {
        return MessageDecoder.decode(byteBuffer, readBody, true, false);
    }

    public static byte[] encode(MessageExt messageExt, boolean needCompress) throws Exception {
        ByteBuffer byteBuffer;
        byte[] body = messageExt.getBody();
        byte[] topics = messageExt.getTopic().getBytes(CHARSET_UTF8);
        byte topicLen = (byte)topics.length;
        String properties = MessageDecoder.messageProperties2String(messageExt.getProperties());
        byte[] propertiesBytes = properties.getBytes(CHARSET_UTF8);
        short propertiesLength = (short)propertiesBytes.length;
        int sysFlag = messageExt.getSysFlag();
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int storehostAddressLength = (sysFlag & 0x20) == 0 ? 8 : 20;
        byte[] newBody = messageExt.getBody();
        if (needCompress && (sysFlag & 1) == 1) {
            Compressor compressor = CompressorFactory.getCompressor(MessageSysFlag.getCompressionType(sysFlag));
            newBody = compressor.compress(body, 5);
        }
        int bodyLength = newBody.length;
        int storeSize = messageExt.getStoreSize();
        if (storeSize > 0) {
            byteBuffer = ByteBuffer.allocate(storeSize);
        } else {
            storeSize = 48 + bornhostLength + 8 + storehostAddressLength + 4 + 8 + 4 + bodyLength + 1 + topicLen + 2 + propertiesLength + 0;
            byteBuffer = ByteBuffer.allocate(storeSize);
        }
        byteBuffer.putInt(storeSize);
        byteBuffer.putInt(-626843481);
        int bodyCRC = messageExt.getBodyCRC();
        byteBuffer.putInt(bodyCRC);
        int queueId = messageExt.getQueueId();
        byteBuffer.putInt(queueId);
        int flag = messageExt.getFlag();
        byteBuffer.putInt(flag);
        long queueOffset = messageExt.getQueueOffset();
        byteBuffer.putLong(queueOffset);
        long physicOffset = messageExt.getCommitLogOffset();
        byteBuffer.putLong(physicOffset);
        byteBuffer.putInt(sysFlag);
        long bornTimeStamp = messageExt.getBornTimestamp();
        byteBuffer.putLong(bornTimeStamp);
        InetSocketAddress bornHost = (InetSocketAddress)messageExt.getBornHost();
        byteBuffer.put(bornHost.getAddress().getAddress());
        byteBuffer.putInt(bornHost.getPort());
        long storeTimestamp = messageExt.getStoreTimestamp();
        byteBuffer.putLong(storeTimestamp);
        InetSocketAddress serverHost = (InetSocketAddress)messageExt.getStoreHost();
        byteBuffer.put(serverHost.getAddress().getAddress());
        byteBuffer.putInt(serverHost.getPort());
        int reconsumeTimes = messageExt.getReconsumeTimes();
        byteBuffer.putInt(reconsumeTimes);
        long preparedTransactionOffset = messageExt.getPreparedTransactionOffset();
        byteBuffer.putLong(preparedTransactionOffset);
        byteBuffer.putInt(bodyLength);
        byteBuffer.put(newBody);
        byteBuffer.put(topicLen);
        byteBuffer.put(topics);
        byteBuffer.putShort(propertiesLength);
        byteBuffer.put(propertiesBytes);
        return byteBuffer.array();
    }

    public static byte[] encodeUniquely(MessageExt messageExt, boolean needCompress) throws IOException {
        ByteBuffer byteBuffer;
        byte[] body = messageExt.getBody();
        byte[] topics = messageExt.getTopic().getBytes(CHARSET_UTF8);
        byte topicLen = (byte)topics.length;
        String properties = MessageDecoder.messageProperties2String(messageExt.getProperties());
        byte[] propertiesBytes = properties.getBytes(CHARSET_UTF8);
        short propertiesLength = (short)propertiesBytes.length;
        int sysFlag = messageExt.getSysFlag();
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        byte[] newBody = messageExt.getBody();
        if (needCompress && (sysFlag & 1) == 1) {
            newBody = UtilAll.compress(body, 5);
        }
        int bodyLength = newBody.length;
        int storeSize = messageExt.getStoreSize();
        if (storeSize > 0) {
            byteBuffer = ByteBuffer.allocate(storeSize - 8);
        } else {
            storeSize = 48 + bornhostLength + 4 + 8 + 4 + bodyLength + 1 + topicLen + 2 + propertiesLength;
            byteBuffer = ByteBuffer.allocate(storeSize);
        }
        byteBuffer.putInt(storeSize);
        byteBuffer.putInt(-626843481);
        int bodyCRC = messageExt.getBodyCRC();
        byteBuffer.putInt(bodyCRC);
        int queueId = messageExt.getQueueId();
        byteBuffer.putInt(queueId);
        int flag = messageExt.getFlag();
        byteBuffer.putInt(flag);
        long queueOffset = messageExt.getQueueOffset();
        byteBuffer.putLong(queueOffset);
        long physicOffset = messageExt.getCommitLogOffset();
        byteBuffer.putLong(physicOffset);
        byteBuffer.putInt(sysFlag);
        long bornTimeStamp = messageExt.getBornTimestamp();
        byteBuffer.putLong(bornTimeStamp);
        InetSocketAddress bornHost = (InetSocketAddress)messageExt.getBornHost();
        byteBuffer.put(bornHost.getAddress().getAddress());
        byteBuffer.putInt(bornHost.getPort());
        int reconsumeTimes = messageExt.getReconsumeTimes();
        byteBuffer.putInt(reconsumeTimes);
        long preparedTransactionOffset = messageExt.getPreparedTransactionOffset();
        byteBuffer.putLong(preparedTransactionOffset);
        byteBuffer.putInt(bodyLength);
        byteBuffer.put(newBody);
        byteBuffer.put(topicLen);
        byteBuffer.put(topics);
        byteBuffer.putShort(propertiesLength);
        byteBuffer.put(propertiesBytes);
        return byteBuffer.array();
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody, boolean deCompressBody) {
        return MessageDecoder.decode(byteBuffer, readBody, deCompressBody, false);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody, boolean deCompressBody, boolean isClient) {
        return MessageDecoder.decode(byteBuffer, readBody, deCompressBody, isClient, false, false);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody, boolean deCompressBody, boolean isClient, boolean isSetPropertiesString) {
        return MessageDecoder.decode(byteBuffer, readBody, deCompressBody, isClient, isSetPropertiesString, false);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody, boolean deCompressBody, boolean isClient, boolean isSetPropertiesString, boolean checkCRC) {
        try {
            MessageExt msgExt = isClient ? new MessageClientExt() : new MessageExt();
            int storeSize = byteBuffer.getInt();
            msgExt.setStoreSize(storeSize);
            int magicCode = byteBuffer.getInt();
            MessageVersion version = MessageVersion.valueOfMagicCode(magicCode);
            int bodyCRC = byteBuffer.getInt();
            msgExt.setBodyCRC(bodyCRC);
            int queueId = byteBuffer.getInt();
            msgExt.setQueueId(queueId);
            int flag = byteBuffer.getInt();
            msgExt.setFlag(flag);
            long queueOffset = byteBuffer.getLong();
            msgExt.setQueueOffset(queueOffset);
            long physicOffset = byteBuffer.getLong();
            msgExt.setCommitLogOffset(physicOffset);
            int sysFlag = byteBuffer.getInt();
            msgExt.setSysFlag(sysFlag);
            long bornTimeStamp = byteBuffer.getLong();
            msgExt.setBornTimestamp(bornTimeStamp);
            int bornhostIPLength = (sysFlag & 0x10) == 0 ? 4 : 16;
            byte[] bornHost = new byte[bornhostIPLength];
            byteBuffer.get(bornHost, 0, bornhostIPLength);
            int port = byteBuffer.getInt();
            msgExt.setBornHost(new InetSocketAddress(InetAddress.getByAddress(bornHost), port));
            long storeTimestamp = byteBuffer.getLong();
            msgExt.setStoreTimestamp(storeTimestamp);
            int storehostIPLength = (sysFlag & 0x20) == 0 ? 4 : 16;
            byte[] storeHost = new byte[storehostIPLength];
            byteBuffer.get(storeHost, 0, storehostIPLength);
            port = byteBuffer.getInt();
            msgExt.setStoreHost(new InetSocketAddress(InetAddress.getByAddress(storeHost), port));
            int reconsumeTimes = byteBuffer.getInt();
            msgExt.setReconsumeTimes(reconsumeTimes);
            long preparedTransactionOffset = byteBuffer.getLong();
            msgExt.setPreparedTransactionOffset(preparedTransactionOffset);
            int bodyLen = byteBuffer.getInt();
            if (bodyLen > 0) {
                if (readBody) {
                    int crc;
                    byte[] body = new byte[bodyLen];
                    byteBuffer.get(body);
                    if (checkCRC && (crc = UtilAll.crc32(body, 0, bodyLen)) != bodyCRC) {
                        throw new Exception("Msg crc is error!");
                    }
                    if (deCompressBody && (sysFlag & 1) == 1) {
                        Compressor compressor = CompressorFactory.getCompressor(MessageSysFlag.getCompressionType(sysFlag));
                        body = compressor.decompress(body);
                    }
                    msgExt.setBody(body);
                } else {
                    byteBuffer.position(byteBuffer.position() + bodyLen);
                }
            }
            int topicLen = version.getTopicLength(byteBuffer);
            byte[] topic = new byte[topicLen];
            byteBuffer.get(topic);
            msgExt.setTopic(new String(topic, CHARSET_UTF8));
            short propertiesLength = byteBuffer.getShort();
            if (propertiesLength > 0) {
                Map<String, String> map;
                byte[] properties = new byte[propertiesLength];
                byteBuffer.get(properties);
                String propertiesString = new String(properties, CHARSET_UTF8);
                if (!isSetPropertiesString) {
                    map = MessageDecoder.string2messageProperties(propertiesString);
                    msgExt.setProperties(map);
                } else {
                    map = MessageDecoder.string2messageProperties(propertiesString);
                    map.put("propertiesString", propertiesString);
                    msgExt.setProperties(map);
                }
            }
            int msgIDLength = storehostIPLength + 4 + 8;
            ByteBuffer byteBufferMsgId = ByteBuffer.allocate(msgIDLength);
            String msgId = MessageDecoder.createMessageId(byteBufferMsgId, msgExt.getStoreHostBytes(), msgExt.getCommitLogOffset());
            msgExt.setMsgId(msgId);
            if (isClient) {
                ((MessageClientExt)msgExt).setOffsetMsgId(msgId);
            }
            return msgExt;
        }
        catch (Exception e) {
            byteBuffer.position(byteBuffer.limit());
            return null;
        }
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer) {
        return MessageDecoder.decodes(byteBuffer, true);
    }

    public static List<MessageExt> decodesBatch(ByteBuffer byteBuffer, boolean readBody, boolean decompressBody, boolean isClient) {
        MessageExt msgExt;
        ArrayList<MessageExt> msgExts = new ArrayList<MessageExt>();
        while (byteBuffer.hasRemaining() && null != (msgExt = MessageDecoder.decode(byteBuffer, readBody, decompressBody, isClient))) {
            msgExts.add(msgExt);
        }
        return msgExts;
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer, boolean readBody) {
        MessageExt msgExt;
        ArrayList<MessageExt> msgExts = new ArrayList<MessageExt>();
        while (byteBuffer.hasRemaining() && null != (msgExt = MessageDecoder.clientDecode(byteBuffer, readBody))) {
            msgExts.add(msgExt);
        }
        return msgExts;
    }

    public static String messageProperties2String(Map<String, String> properties) {
        if (properties == null) {
            return "";
        }
        int len = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            if (name != null) {
                len += name.length();
            }
            len += value.length();
            len += 2;
        }
        StringBuilder sb = new StringBuilder(len);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            sb.append(name);
            sb.append('\u0001');
            sb.append(value);
            sb.append('\u0002');
        }
        return sb.toString();
    }

    public static Map<String, String> string2messageProperties(String properties) {
        HashMap<String, String> map = new HashMap<String, String>(128);
        if (properties != null) {
            int len = properties.length();
            int index = 0;
            while (index < len) {
                int kvSepIndex;
                int newIndex = properties.indexOf(2, index);
                if (newIndex < 0) {
                    newIndex = len;
                }
                if (newIndex - index >= 3 && (kvSepIndex = properties.indexOf(1, index)) > index && kvSepIndex < newIndex - 1) {
                    String k = properties.substring(index, kvSepIndex);
                    String v = properties.substring(kvSepIndex + 1, newIndex);
                    map.put(k, v);
                }
                index = newIndex + 1;
            }
        }
        return map;
    }

    public static byte[] encodeMessage(Message message) {
        byte[] body = message.getBody();
        int bodyLen = body.length;
        String properties = MessageDecoder.messageProperties2String(message.getProperties());
        byte[] propertiesBytes = properties.getBytes(CHARSET_UTF8);
        short propertiesLength = (short)propertiesBytes.length;
        int storeSize = 20 + bodyLen + 2 + propertiesLength;
        ByteBuffer byteBuffer = ByteBuffer.allocate(storeSize);
        byteBuffer.putInt(storeSize);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        int flag = message.getFlag();
        byteBuffer.putInt(flag);
        byteBuffer.putInt(bodyLen);
        byteBuffer.put(body);
        byteBuffer.putShort(propertiesLength);
        byteBuffer.put(propertiesBytes);
        return byteBuffer.array();
    }

    public static Message decodeMessage(ByteBuffer byteBuffer) throws Exception {
        Message message = new Message();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        int flag = byteBuffer.getInt();
        message.setFlag(flag);
        int bodyLen = byteBuffer.getInt();
        byte[] body = new byte[bodyLen];
        byteBuffer.get(body);
        message.setBody(body);
        short propertiesLen = byteBuffer.getShort();
        byte[] propertiesBytes = new byte[propertiesLen];
        byteBuffer.get(propertiesBytes);
        message.setProperties(MessageDecoder.string2messageProperties(new String(propertiesBytes, CHARSET_UTF8)));
        return message;
    }

    public static byte[] encodeMessages(List<Message> messages) {
        ArrayList<byte[]> encodedMessages = new ArrayList<byte[]>(messages.size());
        int allSize = 0;
        for (Message message : messages) {
            byte[] tmp = MessageDecoder.encodeMessage(message);
            encodedMessages.add(tmp);
            allSize += tmp.length;
        }
        byte[] allBytes = new byte[allSize];
        int pos = 0;
        for (byte[] bytes : encodedMessages) {
            System.arraycopy(bytes, 0, allBytes, pos, bytes.length);
            pos += bytes.length;
        }
        return allBytes;
    }

    public static List<Message> decodeMessages(ByteBuffer byteBuffer) throws Exception {
        ArrayList<Message> msgs = new ArrayList<Message>();
        while (byteBuffer.hasRemaining()) {
            Message msg = MessageDecoder.decodeMessage(byteBuffer);
            msgs.add(msg);
        }
        return msgs;
    }

    public static void decodeMessage(MessageExt messageExt, List<MessageExt> list) throws Exception {
        List<Message> messages = MessageDecoder.decodeMessages(ByteBuffer.wrap(messageExt.getBody()));
        for (int i = 0; i < messages.size(); ++i) {
            Message message = messages.get(i);
            MessageClientExt messageClientExt = new MessageClientExt();
            messageClientExt.setTopic(messageExt.getTopic());
            messageClientExt.setQueueOffset(messageExt.getQueueOffset() + (long)i);
            messageClientExt.setQueueId(messageExt.getQueueId());
            messageClientExt.setFlag(message.getFlag());
            MessageAccessor.setProperties(messageClientExt, message.getProperties());
            messageClientExt.setBody(message.getBody());
            messageClientExt.setStoreHost(messageExt.getStoreHost());
            messageClientExt.setBornHost(messageExt.getBornHost());
            messageClientExt.setBornTimestamp(messageExt.getBornTimestamp());
            messageClientExt.setStoreTimestamp(messageExt.getStoreTimestamp());
            messageClientExt.setSysFlag(messageExt.getSysFlag());
            messageClientExt.setCommitLogOffset(messageExt.getCommitLogOffset());
            messageClientExt.setWaitStoreMsgOK(messageExt.isWaitStoreMsgOK());
            list.add(messageClientExt);
        }
    }

    public static int countInnerMsgNum(ByteBuffer buffer) {
        int count = 0;
        while (buffer.hasRemaining()) {
            ++count;
            int currPos = buffer.position();
            int size = buffer.getInt();
            buffer.position(currPos + size);
        }
        return count;
    }
}

