/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logappender.common;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;

public class ProducerInstance {
    public static final String APPENDER_TYPE = "APPENDER_TYPE";
    public static final String LOG4J_APPENDER = "LOG4J_APPENDER";
    public static final String LOG4J2_APPENDER = "LOG4J2_APPENDER";
    public static final String LOGBACK_APPENDER = "LOGBACK_APPENDER";
    public static final String DEFAULT_GROUP = "rocketmq_appender";
    private ConcurrentHashMap<String, MQProducer> producerMap = new ConcurrentHashMap();
    private static ProducerInstance instance = new ProducerInstance();

    public static ProducerInstance getProducerInstance() {
        return instance;
    }

    private String genKey(String nameServerAddress, String group) {
        return nameServerAddress + "_" + group;
    }

    public MQProducer getInstance(String nameServerAddress, String group) throws MQClientException {
        String genKey;
        MQProducer p;
        if (StringUtils.isBlank((CharSequence)group)) {
            group = DEFAULT_GROUP;
        }
        if ((p = ProducerInstance.getProducerInstance().producerMap.get(genKey = this.genKey(nameServerAddress, group))) != null) {
            return p;
        }
        DefaultMQProducer defaultMQProducer = new DefaultMQProducer(group);
        defaultMQProducer.setNamesrvAddr(nameServerAddress);
        MQProducer beforeProducer = null;
        beforeProducer = ProducerInstance.getProducerInstance().producerMap.putIfAbsent(genKey, (MQProducer)defaultMQProducer);
        if (beforeProducer != null) {
            return beforeProducer;
        }
        defaultMQProducer.start();
        return defaultMQProducer;
    }

    public void removeAndClose(String nameServerAddress, String group) {
        String genKey;
        MQProducer producer;
        if (group == null) {
            group = DEFAULT_GROUP;
        }
        if ((producer = ProducerInstance.getProducerInstance().producerMap.remove(genKey = this.genKey(nameServerAddress, group))) != null) {
            producer.shutdown();
        }
    }

    public void closeAll() {
        Set<Map.Entry<String, MQProducer>> entries = ProducerInstance.getProducerInstance().producerMap.entrySet();
        for (Map.Entry<String, MQProducer> entry : entries) {
            ProducerInstance.getProducerInstance().producerMap.remove(entry.getKey());
            entry.getValue().shutdown();
        }
    }
}

