/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logappender.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logappender.common.ProducerInstance;

public class RocketmqLog4jAppender
extends AppenderSkeleton {
    private String tag;
    private String topic;
    private boolean locationInfo;
    private MQProducer producer;
    private String nameServerAddress;
    private String producerGroup;

    public void activateOptions() {
        LogLog.debug((String)"Getting initial context.");
        if (!this.checkEntryConditions()) {
            return;
        }
        try {
            this.producer = ProducerInstance.getProducerInstance().getInstance(this.nameServerAddress, this.producerGroup);
        }
        catch (Exception e) {
            LogLog.error((String)("activateOptions nameserver:" + this.nameServerAddress + " group:" + this.producerGroup + " " + e.getMessage()));
        }
    }

    public void append(LoggingEvent event) {
        if (null == this.producer) {
            return;
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        byte[] data = this.layout.format(event).getBytes();
        try {
            Message msg = new Message(this.topic, this.tag, data);
            msg.getProperties().put("APPENDER_TYPE", "LOG4J_APPENDER");
            this.producer.sendOneway(msg);
        }
        catch (Exception e) {
            String msg = new String(data);
            this.errorHandler.error("Could not send message in RocketmqLog4jAppender [" + this.name + "].Message is :" + msg, e, 0);
        }
    }

    protected boolean checkEntryConditions() {
        String fail = null;
        if (this.topic == null) {
            fail = "No topic";
        } else if (this.tag == null) {
            fail = "No tag";
        }
        if (fail != null) {
            this.errorHandler.error(fail + " for RocketmqLog4jAppender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug((String)("Closing RocketmqLog4jAppender [" + this.name + "]."));
        this.closed = true;
        try {
            ProducerInstance.getProducerInstance().removeAndClose(this.nameServerAddress, this.producerGroup);
        }
        catch (Exception e) {
            LogLog.error((String)("Closing RocketmqLog4jAppender [" + this.name + "] nameServerAddress:" + this.nameServerAddress + " group:" + this.producerGroup + " " + e.getMessage()));
        }
        this.producer = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    protected MQProducer getProducer() {
        return this.producer;
    }

    public void setNameServerAddress(String nameServerAddress) {
        this.nameServerAddress = nameServerAddress;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }
}

