/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.autoconfigure;

import java.util.Objects;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQReplyListener;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.beans.factory.config.BeanDefinitionCustomizer"})
public class ListenerContainerConfiguration1X
extends ListenerContainerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerConfiguration1X.class);

    public ListenerContainerConfiguration1X(RocketMQMessageConverter rocketMQMessageConverter, StandardEnvironment environment, RocketMQProperties rocketMQProperties) {
        super(rocketMQMessageConverter, environment, rocketMQProperties);
    }

    @Override
    public void registerRocketMQListenerContainerBean(Object bean, RocketMQMessageListener annotation, String containerBeanName, GenericApplicationContext genericApplicationContext, StandardEnvironment environment, RocketMQProperties rocketMQProperties, RocketMQMessageConverter rocketMQMessageConverter) {
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultRocketMQListenerContainer.class);
        beanBuilder.addPropertyValue("rocketMQMessageListener", (Object)annotation);
        beanBuilder.addPropertyValue("nameServer", (Object)rocketMQProperties.getNameServer());
        String accessChannel = environment.resolvePlaceholders(annotation.accessChannel());
        if (!StringUtils.isEmpty((Object)accessChannel)) {
            beanBuilder.addPropertyValue("accessChannel", (Object)AccessChannel.valueOf((String)accessChannel));
        }
        beanBuilder.addPropertyValue("topic", (Object)environment.resolvePlaceholders(annotation.topic()));
        beanBuilder.addPropertyValue("selectorExpression", (Object)environment.resolvePlaceholders(annotation.selectorExpression()));
        beanBuilder.addPropertyValue("consumerGroup", (Object)environment.resolvePlaceholders(annotation.consumerGroup()));
        if (RocketMQListener.class.isAssignableFrom(bean.getClass())) {
            beanBuilder.addPropertyValue("rocketMQListener", (Object)((RocketMQListener)bean));
        } else if (RocketMQReplyListener.class.isAssignableFrom(bean.getClass())) {
            beanBuilder.addPropertyValue("rocketMQReplyListener", (Object)((RocketMQReplyListener)bean));
        }
        if (Objects.nonNull(rocketMQMessageConverter)) {
            beanBuilder.addPropertyValue("messageConverter", (Object)rocketMQMessageConverter.getMessageConverter());
        }
        beanBuilder.addPropertyValue("name", (Object)containerBeanName);
        beanBuilder.setDestroyMethodName("destroy");
        genericApplicationContext.registerBeanDefinition(containerBeanName, (BeanDefinition)beanBuilder.getBeanDefinition());
    }
}

