/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.test.base.IntegrationTestBase;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.clientinterface.AbstractMQConsumer;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.factory.ConsumerFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.util.MQAdmin;
import org.apache.rocketmq.test.util.MQRandomUtils;

public class BaseConf {
    protected static String nsAddr;
    protected static String broker1Name;
    protected static String broker2Name;
    protected static String clusterName;
    protected static int brokerNum;
    protected static int waitTime;
    protected static int consumeTime;
    protected static NamesrvController namesrvController;
    protected static BrokerController brokerController1;
    protected static BrokerController brokerController2;
    protected static List<Object> mqClients;
    protected static boolean debug;
    private static Logger log;

    public static String initTopic() {
        String topic = MQRandomUtils.getRandomTopic();
        IntegrationTestBase.initTopic(topic, nsAddr, clusterName);
        return topic;
    }

    public static String initConsumerGroup() {
        String group = MQRandomUtils.getRandomConsumerGroup();
        return BaseConf.initConsumerGroup(group);
    }

    public static String initConsumerGroup(String group) {
        MQAdmin.createSub((String)nsAddr, (String)clusterName, (String)group);
        return group;
    }

    public static RMQNormalProducer getProducer(String nsAddr, String topic) {
        return BaseConf.getProducer(nsAddr, topic, false);
    }

    public static RMQNormalProducer getProducer(String nsAddr, String topic, boolean useTLS) {
        RMQNormalProducer producer = new RMQNormalProducer(nsAddr, topic, useTLS);
        if (debug) {
            producer.setDebug();
        }
        mqClients.add(producer);
        return producer;
    }

    public static RMQNormalProducer getProducer(String nsAddr, String topic, String producerGoup, String instanceName) {
        RMQNormalProducer producer = new RMQNormalProducer(nsAddr, topic, producerGoup, instanceName);
        if (debug) {
            producer.setDebug();
        }
        mqClients.add(producer);
        return producer;
    }

    public static RMQAsyncSendProducer getAsyncProducer(String nsAddr, String topic) {
        RMQAsyncSendProducer producer = new RMQAsyncSendProducer(nsAddr, topic);
        if (debug) {
            producer.setDebug();
        }
        mqClients.add(producer);
        return producer;
    }

    public static RMQNormalConsumer getConsumer(String nsAddr, String topic, String subExpression, AbstractListener listener) {
        return BaseConf.getConsumer(nsAddr, topic, subExpression, listener, false);
    }

    public static RMQNormalConsumer getConsumer(String nsAddr, String topic, String subExpression, AbstractListener listener, boolean useTLS) {
        String consumerGroup = BaseConf.initConsumerGroup();
        return BaseConf.getConsumer(nsAddr, consumerGroup, topic, subExpression, listener, useTLS);
    }

    public static RMQNormalConsumer getConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listener) {
        return BaseConf.getConsumer(nsAddr, consumerGroup, topic, subExpression, listener, false);
    }

    public static RMQNormalConsumer getConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listener, boolean useTLS) {
        RMQNormalConsumer consumer = ConsumerFactory.getRMQNormalConsumer((String)nsAddr, (String)consumerGroup, (String)topic, (String)subExpression, (AbstractListener)listener, (boolean)useTLS);
        if (debug) {
            consumer.setDebug();
        }
        mqClients.add(consumer);
        log.info((Object)String.format("consumer[%s] start,topic[%s],subExpression[%s]", consumerGroup, topic, subExpression));
        return consumer;
    }

    public static void shutdown() {
        try {
            for (Object mqClient : mqClients) {
                if (mqClient instanceof AbstractMQProducer) {
                    ((AbstractMQProducer)mqClient).shutdown();
                    continue;
                }
                ((AbstractMQConsumer)mqClient).shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        waitTime = 5;
        consumeTime = 300000;
        mqClients = new ArrayList<Object>();
        debug = false;
        log = Logger.getLogger(BaseConf.class);
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        namesrvController = IntegrationTestBase.createAndStartNamesrv();
        nsAddr = "127.0.0.1:" + namesrvController.getNettyServerConfig().getListenPort();
        brokerController1 = IntegrationTestBase.createAndStartBroker(nsAddr);
        brokerController2 = IntegrationTestBase.createAndStartBroker(nsAddr);
        clusterName = brokerController1.getBrokerConfig().getBrokerClusterName();
        broker1Name = brokerController1.getBrokerConfig().getBrokerName();
        broker2Name = brokerController2.getBrokerConfig().getBrokerName();
        brokerNum = 2;
    }
}

