/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.test.util.MQAdmin;
import org.apache.rocketmq.test.util.TestUtils;
import org.junit.Assert;

public class IntegrationTestBase {
    public static InternalLogger logger = InternalLoggerFactory.getLogger(IntegrationTestBase.class);
    protected static final String SEP = File.separator;
    protected static final String BROKER_NAME_PREFIX = "TestBrokerName_";
    protected static final AtomicInteger BROKER_INDEX = new AtomicInteger(0);
    protected static final List<File> TMPE_FILES = new ArrayList<File>();
    protected static final List<BrokerController> BROKER_CONTROLLERS = new ArrayList<BrokerController>();
    protected static final List<NamesrvController> NAMESRV_CONTROLLERS = new ArrayList<NamesrvController>();
    protected static int topicCreateTime = 30000;
    protected static final int COMMIT_LOG_SIZE = 0x10000000;
    protected static final int INDEX_NUM = 1000;
    protected static Random random = new Random();

    private static String createBaseDir() {
        String baseDir = System.getProperty("user.home") + SEP + "unitteststore-" + UUID.randomUUID();
        File file = new File(baseDir);
        if (file.exists()) {
            logger.info(String.format("[%s] has already existed, please back up and remove it for integration tests", baseDir));
            System.exit(1);
        }
        TMPE_FILES.add(file);
        return baseDir;
    }

    public static NamesrvController createAndStartNamesrv() {
        String baseDir = IntegrationTestBase.createBaseDir();
        NamesrvConfig namesrvConfig = new NamesrvConfig();
        NettyServerConfig nameServerNettyServerConfig = new NettyServerConfig();
        namesrvConfig.setKvConfigPath(baseDir + SEP + "namesrv" + SEP + "kvConfig.json");
        namesrvConfig.setConfigStorePath(baseDir + SEP + "namesrv" + SEP + "namesrv.properties");
        nameServerNettyServerConfig.setListenPort(9000 + random.nextInt(1000));
        NamesrvController namesrvController = new NamesrvController(namesrvConfig, nameServerNettyServerConfig);
        try {
            Assert.assertTrue((boolean)namesrvController.initialize());
            logger.info("Name Server Start:{}", (Object)nameServerNettyServerConfig.getListenPort());
            namesrvController.start();
        }
        catch (Exception e) {
            logger.info("Name Server start failed");
            System.exit(1);
        }
        NAMESRV_CONTROLLERS.add(namesrvController);
        return namesrvController;
    }

    public static BrokerController createAndStartBroker(String nsAddr) {
        String baseDir = IntegrationTestBase.createBaseDir();
        BrokerConfig brokerConfig = new BrokerConfig();
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        MessageStoreConfig storeConfig = new MessageStoreConfig();
        brokerConfig.setBrokerName(BROKER_NAME_PREFIX + BROKER_INDEX.getAndIncrement());
        brokerConfig.setBrokerIP1("127.0.0.1");
        brokerConfig.setNamesrvAddr(nsAddr);
        brokerConfig.setEnablePropertyFilter(true);
        storeConfig.setStorePathRootDir(baseDir);
        storeConfig.setStorePathCommitLog(baseDir + SEP + "commitlog");
        storeConfig.setHaListenPort(8000 + random.nextInt(1000));
        storeConfig.setMapedFileSizeCommitLog(0x10000000);
        storeConfig.setMaxIndexNum(1000);
        storeConfig.setMaxHashSlotNum(4000);
        nettyServerConfig.setListenPort(10000 + random.nextInt(1000));
        BrokerController brokerController = new BrokerController(brokerConfig, nettyServerConfig, nettyClientConfig, storeConfig);
        try {
            Assert.assertTrue((boolean)brokerController.initialize());
            logger.info("Broker Start name:{} addr:{}", (Object)brokerConfig.getBrokerName(), (Object)brokerController.getBrokerAddr());
            brokerController.start();
        }
        catch (Exception e) {
            logger.info("Broker start failed");
            System.exit(1);
        }
        BROKER_CONTROLLERS.add(brokerController);
        return brokerController;
    }

    public static boolean initTopic(String topic, String nsAddr, String clusterName, int queueNumbers) {
        boolean createResult;
        long startTime = System.currentTimeMillis();
        while (!(createResult = MQAdmin.createTopic((String)nsAddr, (String)clusterName, (String)topic, (int)queueNumbers))) {
            if (System.currentTimeMillis() - startTime > (long)topicCreateTime) {
                Assert.fail((String)String.format("topic[%s] is created failed after:%d ms", topic, System.currentTimeMillis() - startTime));
                break;
            }
            TestUtils.waitForMoment((long)500L);
        }
        return createResult;
    }

    public static boolean initTopic(String topic, String nsAddr, String clusterName) {
        return IntegrationTestBase.initTopic(topic, nsAddr, clusterName, 8);
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                IntegrationTestBase.deleteFile(file1);
            }
            file.delete();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    for (BrokerController brokerController : BROKER_CONTROLLERS) {
                        if (brokerController == null) continue;
                        brokerController.shutdown();
                    }
                    for (BrokerController brokerController : BROKER_CONTROLLERS) {
                        if (brokerController == null) continue;
                        brokerController.getMessageStore().destroy();
                    }
                    for (NamesrvController namesrvController : NAMESRV_CONTROLLERS) {
                        if (namesrvController == null) continue;
                        namesrvController.shutdown();
                    }
                    for (File file : TMPE_FILES) {
                        UtilAll.deleteFile((File)file);
                    }
                }
                catch (Exception e) {
                    logger.error("Shutdown error", (Throwable)e);
                }
            }
        });
    }
}

