/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.balance;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalMsgDynamicBalanceIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = NormalMsgDynamicBalanceIT.initTopic();
        logger.info((Object)String.format("use topic: %s !", this.topic));
        this.producer = NormalMsgDynamicBalanceIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoConsumerAndCrashOne() {
        int msgSize = 400;
        RMQNormalConsumer consumer1 = NormalMsgDynamicBalanceIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer2 = NormalMsgDynamicBalanceIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)waitTime);
        this.producer.send((long)msgSize);
        MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        consumer2.shutdown();
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)msgSize, (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size() - msgSize, VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size()});
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
    }

    @Test
    public void test3ConsumerAndCrashOne() {
        int msgSize = 400;
        RMQNormalConsumer consumer1 = NormalMsgDynamicBalanceIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer2 = NormalMsgDynamicBalanceIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer3 = NormalMsgDynamicBalanceIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)waitTime);
        this.producer.send((long)msgSize);
        MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        consumer3.shutdown();
        this.producer.clearMsg();
        consumer1.clearMsg();
        consumer2.clearMsg();
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)msgSize, (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size()});
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
    }
}

