/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.normal;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadCastIT;
import org.apache.rocketmq.test.client.consumer.broadcast.normal.NormalMsgTwoSameGroupConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadCastNormalMsgNotRecvIT
extends BaseBroadCastIT {
    private static Logger logger = Logger.getLogger(NormalMsgTwoSameGroupConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.printSeperator();
        this.topic = BroadCastNormalMsgNotRecvIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = BroadCastNormalMsgNotRecvIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadCastIT.shutdown();
    }

    @Test
    public void testNotConsumeAfterConsume() throws Exception {
        int msgSize = 16;
        String group = BroadCastNormalMsgNotRecvIT.initConsumerGroup();
        RMQBroadCastConsumer consumer1 = BroadCastNormalMsgNotRecvIT.getBroadCastConsumer(nsAddr, group, this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_1"));
        Thread.sleep(3000L);
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        RMQBroadCastConsumer consumer2 = BroadCastNormalMsgNotRecvIT.getBroadCastConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_2"));
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), waitTime);
        Truth.assertThat((Integer)consumer2.getListener().getAllMsgBody().size()).isEqualTo((Object)0);
    }
}

